import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/confirm_dialog.dart';
import 'package:account_center/widget/global_card_widget.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'new_enterprise_logic.dart';

///创建企业
class NewEnterprisePage extends StatelessWidget {
  final logic = Get.find<NewEnterpriseLogic>();
  final state = Get.find<NewEnterpriseLogic>().state;

  NewEnterprisePage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      backgroundColor: Colors.white,
      appBar: MyAppBar(logic.isReConfirm ? '重新认证' : '创建企业'),
      body: _bodyContent(context),
    );
  }

  Widget _bodyContent(context) {
    return GetBuilder<NewEnterpriseLogic>(builder: (logic) {
      return Column(
        children: [
          Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Padding(
                  padding: const EdgeInsets.only(left: 30, top: 45),
                  child: Text(
                    "填写认证资料",
                    style: TextStyle(
                        fontSize: 22,
                        color: Colors.black,
                        fontWeight: FontWeight.bold),
                  ),
                ),
                _itemView(
                    "填写企业基础信息", "完成企业的基础信息，需要营业执照", state.isCompletedBasic, () {
                  logic.goToBasicPage();
                }, marginTop: 30),
                _itemView("填写企业代理人信息", "完成代理人信息，需要身份证", false, () {
                  logic.goToProxyPersonPage();
                }),
                _itemView("填写企业法人信息", "完成法人信息，需要身份证", false, () {
                  logic.goToLegalPersonPage();
                }),
              ],
            ),
          ),
          // _readAndApply(context),
          _itemBottomBtn(context)
        ],
      );
    });
  }

  Widget _itemView(
      String title, String describe, bool isCompleted, VoidCallback onTap,
      {double marginTop = 15}) {
    return GlobalCardWidget(
      isHeaderVis: true,
      isVisHintFill: isCompleted,
      onTab: onTap,
      backgroundColor: const Color(0xFFF2F1F6),
      marginLeft: 25,
      marginRight: 25,
      marginTop: marginTop,
      paddingAll: 20,
      elevation: 0,
      centerWidget: _itemContent(title, describe, isCompleted, () {
        onTap();
      }, marginTop: 15),
      hintFillWidget: Text(
        "去填写",
        style: TextStyle(color: const Color(0xffB4BAC6)),
      ),
    );
  }

  Widget _itemContent(
    String title,
    String describe,
    bool isCompleted,
    VoidCallback onTap, {
    double marginTop = 15,
  }) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          title,
          style: TextStyle(fontSize: 16),
        ),
        vGap10,
        Offstage(
          offstage: isCompleted,
          child: Text(
            describe,
            style: TextStyle(fontSize: 12, color: const Color(0xffA4A8B1)),
          ),
        ),
        Offstage(
          offstage: !isCompleted,
          child: Row(
            children: [
              Text(
                '已完成',
                style: TextStyle(
                  fontSize: 12,
                  color: Color(0xff00B444),
                ),
              ),
              hGap2,
              Icon(
                Icons.check,
                color: Color(0xff00B444),
                size: 15,
              )
            ],
          ),
        ),
      ],
    );
  }

  ///我已阅读并同意
  Widget _readAndApply(context) {
    return Row(
      children: [
        hGap20,
        Checkbox(
          checkColor: Colors.white,
          value: state.isPrivacyChecked,
          shape: CircleBorder(),
          onChanged: (bool? value) {
            logic.checkBoxChange(value);
          },
        ),
        InkWell(
          onTap: () {
            ToastUtil.showToast('哈喽');
          },
          child: Text.rich(TextSpan(children: [
            TextSpan(text: '我已阅读并同意'),
            TextSpan(text: '《公司隐私协议》', style: TextStyle(color: Colors.blue)),
          ])),
        )
      ],
    );
  }

  ///底部按钮
  Widget _itemBottomBtn(context) {
    return Container(
        margin: EdgeInsets.only(left: 10, right: 10, bottom: 20),
        width: double.infinity,
        child: ButtonPublicRadius(
          onPress: () {
            if (logic.checkConfirm()) {
              _cancelRoleDialog(context);
            }
          },
          text: "提交申请",
        ));
  }

  void _cancelRoleDialog(context) {
    Get.dialog(
      ConfirmDialog(
        content: logic.isReConfirm ? "确认重新认证？" : '确认创建企业？',
        confirm: () {
          logic.newEnterpriseRequest();
        },
      ),
      useSafeArea: true,
    );
  }
}
