import 'package:account_center/account_center.dart';
import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';

import 'new_enterprise_state.dart';

class NewEnterpriseLogic extends GetxController {
  final NewEnterpriseState state = NewEnterpriseState();

  Map<String, dynamic> params = {
    'companyNo': getCompanyNo(),
    'companyShortName': '',
    'companyShortNameInitials': ''
  };

  bool isReConfirm = true;

  @override
  void onInit() {
    super.onInit();
    state.basicInfo = Get.arguments['basicInfo'];
    state.proxyInfo = Get.arguments['proxyPersonInfo'] ?? {};
    state.legalInfo = Get.arguments['legalPersonInfo'] ?? {};
    isReConfirm = Get.arguments['isReConfirm'] == true;
  }

  ///企业基本信息
  void goToBasicPage() {
    Get.toNamed(RouteConfig.enterpriseBasicInfoPage,
        arguments: {'basicInfo': state.basicInfo})?.then((data) {
      if (data == null) return;
      state.isAbnormal = false;
      state.basicInfo = data;
      params['companyName'] = data['companyName'];
      params['companyGroupCode'] = data['companyGroupCode'];
      params['bankPublicNumber'] = data['bankPublicNumber'];
      params['bankName'] = data['bankName'];
      params['companyAddress'] = data['companyAddress'];
      params['companyBusinessImg'] = data['companyBusinessImg'];
      params['companyType'] = data['applyType'];
      params['businessStartDate'] = data['businessStartDate'];
      params['businessEndDate'] = data['businessEndDate'];
      params['businessLongTermFlag'] = data['businessLongTermFlag'];
      params['businessExpiredFlag'] = data['businessExpiredFlag'];
      if (!_textEmpty(data['companyName']) && data['applyType'] != 0) {
        state.isCompletedBasic = true;
        update();
      }
      /*  if (!_textEmpty(data['companyName']) &&
          !_textEmpty(data['companyGroupCode']) &&
          !_textEmpty(data['bankPublicNumber']) &&
          !_textEmpty(data['bankName']) &&
          !_textEmpty(data['companyAddress']) &&
          !_textEmpty(data['companyBusinessImg'])) {
        state.isCompletedBasic = true;
        update();
      }*/
    });
  }

  ///企业代理人信息
  void goToProxyPersonPage() {
    Get.toNamed(RouteConfig.enterpriseProxyPersonPage,
        arguments: {'proxyInfo': state.proxyInfo})?.then((data) {
      if (data != null) {
        state.proxyInfo = data;
        params['agentName'] = data['agentName'];
        params['agentMobile'] = data['agentMobile'];
        params['agentCardNo'] = data['agentCardNo'];
        params['agentCardFrontImg'] = data['agentCardFrontImg'];
        params['agentCardBackImg'] = data['agentCardBackImg'];
        params['confirmationFileName'] = data['confirmationFileName'];
        params['agentConfirmation'] = data['agentConfirmation'];
        /* if (!_textEmpty(data['agentName']) &&
            !_textEmpty(data['agentMobile']) &&
            !_textEmpty(data['agentCardNo']) &&
            !_textEmpty(data['agentCardFrontImg']) &&
            !_textEmpty(data['agentCardFrontImg'])) {
          state.isCompletedProxy = true;
          update();
        }*/
        if (!_textEmpty((data['agentConfirmation'])) &&
            !_textEmpty((data['confirmationFileName']))) {
          state.isCompletedProxy = true;
          update();
        }
      }
    });
  }

  ///企业法人信息
  void goToLegalPersonPage() {
    Get.toNamed(RouteConfig.enterpriseLegalPersonPage,
        arguments: {'legalInfo': state.legalInfo})?.then((data) {
      if (data != null) {
        state.legalInfo = data;
        params['legalName'] = data['legalName'];
        params['legalMobile'] = data['legalMobile'];
        params['legalCardNo'] = data['legalCardNo'];
        params['legalCardFrontImg'] = data['legalCardFrontImg'];
        params['legalCardBackImg'] = data['legalCardBackImg'];
        /* if (!_textEmpty(data['legalName']) &&
            !_textEmpty(data['legalMobile']) &&
            !_textEmpty(data['legalCardNo']) &&
            !_textEmpty(data['legalCardFrontImg']) &&
            !_textEmpty(data['legalCardBackImg'])) {
          state.isCompletedLegal = true;
          update();
        }*/
        state.isCompletedLegal = true;
        update();
      }
    });
  }

  bool _textEmpty(value) {
    return TextUtil.isEmpty(value);
  }

  bool checkConfirm() {
    if (state.isCompletedBasic == false) {
      ToastUtil.showToast("请填写企业基础信息");
      return false;
    }
    /*  if (state.isCompletedBasic == false) {
      ToastUtil.showToast("请填写企业基础信息");
      return;
    }
    if (state.isCompletedProxy == false) {
      ToastUtil.showToast("请填写企业代理人信息");
      return;
    }
    if (state.isCompletedLegal == false) {
      ToastUtil.showToast("请填写企业法人信息");
      return;
    }

*/
    // if (!state.isPrivacyChecked) {
    //   ToastUtil.showToast("请认证阅读申请协议并勾选！");
    //   return false;
    // }
    return true;

    ///点击提交给出二次确认弹窗，二次确认以后给出提示：信息已提交成功，请耐心等待后台审核！
    // 页面返回到成为企业申请记录页面；
  }

  void newEnterpriseRequest() {
    fetch(Method.post,
        url: isReConfirm ? HttpApi.updateCompany : HttpApi.newEnterprise,
        onSuccess: (data) {
          ToastUtil.showToast('信息已提交成功，请耐心等待后台审核！');
          Get.back();
        },
        params: params,
        onError: (code, msg) {
          state.isAbnormal = true;
          state.abnormal = msg;
          update();
        });
  }

  void checkBoxChange(bool? value) {
    state.isPrivacyChecked = value!;
    update();
  }
}
