import 'package:account_center/widget/select_image_utils.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'enterprise_legal_person_state.dart';

class EnterpriseLegalPersonLogic extends GetxController {
  final EnterpriseLegalPersonState state = EnterpriseLegalPersonState();

  @override
  void onInit() {
    super.onInit();
    var data = Get.arguments['legalInfo'];
    if (data != null) {
      state.controllerName.text = data['legalName'] ?? '';
      state.controllerPhone.text = data['legalMobile'] ?? '';
      state.controllerIDCard.text = data['legalCardNo'] ?? '';
      state.cardUrlUpPath = data['legalCardFrontImg'] ?? '';
      state.cardUrlDownPath = data['legalCardBackImg'] ?? '';
    }
  }

  void textRequire() {}

  void completed() {
    /*  if (state.controllerName.text.isEmpty) {
      ToastUtil.showToast('请填写姓名');
      return;
    }
    if (state.controllerPhone.text.isEmpty) {
      ToastUtil.showToast('请填写手机号');
      return;
    }
    if (state.controllerIDCard.text.isEmpty) {
      ToastUtil.showToast('请填写身份证号');
      return;
    }
   if (state.cardUrlUpPath.isNullOrEmpty()) {
      ToastUtil.showToast('请上传身份证正面');
      return;
    }
    if (state.cardUrlDownPath.isNullOrEmpty()) {
      ToastUtil.showToast('请上传身份证国徽面');
      return;
    }*/
    backResult();
  }

  void backResult() {
    Map<String, dynamic> params = {
      'legalName': state.controllerName.text,
      'legalMobile': state.controllerPhone.text,
      'legalCardNo': state.controllerIDCard.text,
      'legalCardFrontImg': state.cardUrlUpPath, //身份证正面
      'legalCardBackImg': state.cardUrlDownPath, //身份证反面
    };
    unFocus();
    Get.back(result: params);
  }

  void cameraCapture(bool isUp) {
    selectPicType(onSuccess: (data) {
      _imageUrl(isUp, data);
      update();
    });
  }

  void _imageUrl(bool isUp, String data) {
    if (isUp) {
      state.cardUrlUpPath = data;
    } else {
      state.cardUrlDownPath = data;
    }
  }

  void deleteImage(bool isUp) {
    _imageUrl(isUp, '');
    update();
  }

  void unFocus() {
    FocusManager.instance.primaryFocus?.unfocus();
  }
}
