import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/enterprise/join_or_new_enterprise_page/enterprise_see_widget.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'enterprise_basic_info_see_logic.dart';

///查看  企业基础信息
class EnterpriseBasicInfoSeePage extends StatelessWidget {
  final logic = Get.find<EnterpriseBasicInfoSeeLogic>();
  final state = Get.find<EnterpriseBasicInfoSeeLogic>().state;

  EnterpriseBasicInfoSeePage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar(
        '企业基础信息',
      ),
      body: _bodyContent(context),
    );
  }

  Widget _bodyContent(context) {
    return GetBuilder<EnterpriseBasicInfoSeeLogic>(builder: (logic) {
      return Container(
        padding: EdgeInsets.only(top: state.businessExpiredFlag != 0 ? 10 : 0),
        child: SingleChildScrollView(
          child: Column(
            children: [
              Visibility(
                visible: state.businessExpiredFlag == 1,
                child: topTip(1),
              ),
              Visibility(
                visible: state.businessExpiredFlag == 2,
                child: topTip(2),
              ),
              EnterpriseInfoWidget.formRow('公司名称', state.companyName),
              EnterpriseInfoWidget.formRow('统一社会信用代码', state.companyGroupCode),
              EnterpriseInfoWidget.formRow('银行对公账号', state.bankPublicNumber),
              EnterpriseInfoWidget.formRow('银行名称', state.bankName),
              EnterpriseInfoWidget.formRow('公司地址', state.companyAddress),
              FormRow(
                title: '营业执照',
                crossAxisAlignment: CrossAxisAlignment.start,
                child: state.companyBusinessImg?.isNotEmpty == true
                    ? Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          ImageLoad.idCard(state.companyBusinessImg,
                              fit: BoxFit.fitHeight),
                        ],
                      )
                    : EnterpriseInfoWidget.textWidget('-'),
              ),
              EnterpriseInfoWidget.formRow('营业期限', state.businessStartDate),
              EnterpriseInfoWidget.formRow(
                  '',
                  state.businessLongTermFlag == 0
                      ? state.businessEndDate
                      : '长期'),
            ],
          ),
        ),
      );
    });
  }

  Widget topTip(int val) {
    return Container(
      margin: EdgeInsets.only(bottom: 10),
      height: 40,
      width: double.infinity,
      decoration: BoxDecoration(
        color: Color(val == 1 ? 0xFFFFEFEA : 0xFFFFF9ED),
      ),
      child: Row(
        children: [
          Expanded(
            child: Row(
              children: [
                SizedBox(width: 12),
                ImageLoad.loadAssertImage(
                  val == 1 ? 'danger_sound' : 'warning_sound',
                  width: 18,
                  height: 18,
                ),
                SizedBox(width: 8),
                Text(
                  val == 1 ? '营业执照已到期，请立即更新' : '营业执照即将到期，请及时更新',
                  style: TextStyle(
                    color: Color(val == 1 ? 0xFFEA5529 : 0xFFFF8F1F),
                  ),
                ),
              ],
            ),
          ),
          IconButton(
            onPressed: () {
              logic.hideTopTip();
            },
            icon: Icon(
              Icons.close,
              size: 18,
              color: Color(val == 1 ? 0xFFEA5529 : 0xFFFF8F1F),
            ),
          )
        ],
      ),
    );
  }
}
