import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'enterprise_basic_info_see_state.dart';

class EnterpriseBasicInfoSeeLogic extends GetxController {
  final EnterpriseBasicInfoSeeState state = EnterpriseBasicInfoSeeState();

  @override
  void onInit() {
    var data = Get.arguments;
    if (data != null) {
      state.companyName = data['companyName'];
      state.companyGroupCode = data['companyGroupCode'];
      state.bankPublicNumber = data['bankPublicNumber'];
      state.bankName = data['bankName'] ?? '';
      state.companyAddress = data['companyAddress'];
      state.companyBusinessImg = data['companyBusinessImg'];
      state.businessStartDate = data['businessStartDate'];
      state.businessEndDate = data['businessEndDate'];
      state.businessLongTermFlag = data['businessLongTermFlag'];
      state.businessExpiredFlag = data['businessExpiredFlag'];
    }
    super.onInit();
  }

  void hideTopTip() {
    state.businessExpiredFlag = 0;
    update();
  }
}
