import 'package:account_center/common/utils/bottom_dialog.dart';
import 'package:account_center/common/utils/date_picker.dart' as date_picker;
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:account_center/style/style_widget.dart';
// import 'package:account_center/style/widget/bottom_buttons.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/certificate_select.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'enterprise_basic_info_logic.dart';

///创建企业->填写企业基础信息->企业基础信息
class EnterpriseBasicInfoPage extends StatelessWidget {
  final logic = Get.find<EnterpriseBasicInfoLogic>();
  final state = Get.find<EnterpriseBasicInfoLogic>().state;
  final timeTextStyle = TextStyle(
    color: StyleParams.themeColor,
    fontSize: 16,
    fontWeight: FontWeight.w500,
  );

  EnterpriseBasicInfoPage({super.key});

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        Get.back();
        return false;
      },
      child: Scaffold(
        resizeToAvoidBottomInset: false,
        appBar: MyAppBar(
          '企业基础信息',
          onBack: () {
            Get.back();
          },
        ),
        body: _bodyContent(context),
      ),
    );
  }

  Widget _bodyContent(context) {
    return GetBuilder<EnterpriseBasicInfoLogic>(builder: (logic) {
      return Container(
        padding: EdgeInsets.only(top: 10),
        child: Column(
          children: [
            Expanded(
              child: SingleChildScrollView(
                child: Column(
                  children: [
                    _isManager(),
                    FormInput(
                      isRequired: true,
                      maxLength: 30,
                      title: '公司名称',
                      controller: state.controllerCompanyName,
                      focusNode: state.nodeCompanyName,
                    ),
                    FormInput(
                      maxLength: 18,
                      title: '统一社会信用代码',
                      controller: state.controllerCreditCode,
                      focusNode: state.nodeCreditCode,
                    ),
                    FormInput(
                      maxLength: 30,
                      regExp: "[0-9]",
                      title: '银行对公账号',
                      controller: state.controllerBankNum,
                      focusNode: state.nodeBankNum,
                      inputType: TextInputType.number,
                    ),
                    FormInput(
                      maxLength: 64,
                      title: '银行名称',
                      controller: state.controllerBankName,
                      focusNode: state.nodeBankName,
                    ),
                    FormInput(
                      maxLength: 200,
                      title: '公司地址',
                      controller: state.controllerCompanyAddress,
                      focusNode: state.nodeCompanyAddress,
                    ),
                    FormRow(
                      title: '营业执照',
                      isRequired: state.radioIndex == 2 ? true : false,
                      child: Text(''),
                    ),
                    _businessLicenseWidget(),
                    FormRow(
                      title: '营业期限',
                      isRequired: state.radioIndex == 2 ? true : false,
                      child: _buildTimeRow(
                          logic.startTimeController, '请选择营业执照有效起始日期', () {
                        KeyBoardUtils.hideKeyboard();
                        Get.bottomSheet(
                          date_picker.DatePicker(
                            title: '请选择',
                            type: date_picker.DateType.YMD,
                            (data) {
                              logic.startTimeController.text =
                                  DateUtil.formatDate(data,
                                      format: 'yyyy-MM-dd');
                            },
                          ),
                        );
                      }),
                    ),
                    FormRow(
                      title: '',
                      child: _buildTimeRow(
                          logic.endTimeController, '请选择营业执照有效结束日期', () {
                        KeyBoardUtils.hideKeyboard();
                        BottomDialog.showBottomDialog([
                          ButtonItem(
                            title: '长期',
                            onClick: () {
                              logic.endTimeController.text = '长期';
                            },
                          ),
                          ButtonItem(
                            title: '选择日期',
                            onClick: () {
                              Get.bottomSheet(
                                date_picker.DatePicker(
                                  title: '请选择',
                                  type: date_picker.DateType.YMD,
                                  (data) {
                                    logic.endTimeController.text =
                                        DateUtil.formatDate(data,
                                            format: 'yyyy-MM-dd');
                                  },
                                ),
                              );
                            },
                          ),
                        ]);
                      }),
                    ),
                  ],
                ),
              ),
            ),
            _itemBottomBtn(context)
          ],
        ),
      );
    });
  }

  Widget _buildTimeRow(
      TextEditingController controller, String hint, void Function()? onTap) {
    return GestureTapWidget(
      onTap: onTap,
      child: Row(
        children: [
          Expanded(
            child: TextField(
              enabled: false,
              controller: controller,
              maxLines: null,
              style: timeTextStyle,
              decoration: InputDecoration(
                hintText: hint,
                border: InputBorder.none,
                isDense: true,
                contentPadding: const EdgeInsets.all(0),
              ),
            ),
          ),
          Visibility(
              visible: controller.text.isNotEmpty,
              child: Text(
                '修改',
                style: timeTextStyle,
              ))
        ],
      ),
    );
  }

  ///营业执照
  Widget _businessLicenseWidget() {
    return CertificateSelect(
      title: '营业执照',
      secondTitle: '上传营业执照正面',
      url: state.companyBusinessImg,
      bagUrl: 'business_license',
      onTap: logic.cameraCapture,
      onDelete: logic.deleteBusinessImg,
      license: true,
    );
  }

  ///角色策略
  Widget _isManager() {
    return FormRow(
      title: '申请类型',
      isRequired: true,
      child: Row(
        children: [
          _itemRadio(1, '个人公司'),
          SizedBox(
            width: 30,
          ),
          _itemRadio(2, '企业公司'),
        ],
      ),
    );
  }

  Widget _itemRadio(value, text) {
    return StyleWidget.itemRadio(value, state.radioIndex, text, (value) {
      logic.changeRadio(value);
    });
  }

  ///底部按钮
  Widget _itemBottomBtn(context) {
    return Container(
        margin: EdgeInsets.symmetric(vertical: 20, horizontal: 15),
        width: double.infinity,
        child: ButtonPublicRadius(
          onPress: () {
            logic.completed();
          },
          text: "确定",
        ));
  }
}
