import 'package:account_center/common/utils/reg_exp.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/button_public_radius_outline.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'enterprise_message_certification_logic.dart';

class EnterpriseMessageCertificationPage extends StatelessWidget {
  final logic = Get.find<EnterpriseMessageCertificationLogic>();

  EnterpriseMessageCertificationPage({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar(
        '完善企业信息',
      ),
      body: GetBuilder<EnterpriseMessageCertificationLogic>(builder: (logic) {
        return SingleChildScrollView(
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              SizedBox(
                height: 20,
              ),
              Container(
                margin: EdgeInsets.only(left: 20),
                child: Text(
                  '企业信息',
                  style: TextStyle(fontSize: 14, color: Color(0xff5B6F80)),
                ),
              ),
              SizedBox(
                height: 10,
              ),
              FormInput(
                isRequired: true,
                title: '企业名称',
                focusNode: logic.enterpriseNameNode,
                controller: logic.enterpriseNameController,
                maxLength: 30,
                check: logic.check,
              ),
              FormInput(
                isRequired: true,
                title: '统一社会信用代码',
                focusNode: logic.enterpriseIdNode,
                controller: logic.enterpriseTypeController,
                maxLength: 18,
                regExp: RegExpUtil.num(),
                check: logic.check,
              ),
              SizedBox(
                height: 20,
              ),
              Container(
                margin: EdgeInsets.only(left: 20),
                child: Text(
                  '代理人信息',
                  style: TextStyle(fontSize: 14, color: Color(0xff5B6F80)),
                ),
              ),
              SizedBox(
                height: 10,
              ),
              FormInput(
                isRequired: true,
                title: '姓名',
                focusNode: logic.agentPersonNode,
                controller: logic.agentPersonController,
                check: logic.check,
              ),
              FormInput(
                isRequired: true,
                title: '手机号',
                focusNode: logic.agentPersonPhoneNode,
                controller: logic.agentPersonPhoneController,
                maxLength: 11,
                regExp: RegExpUtil.num(),
                inputType: TextInputType.numberWithOptions(decimal: false),
                check: logic.check,
                showErr: () =>
                    logic.agentPersonPhoneController.text.length != 11,
              ),
              FormInput(
                isRequired: true,
                title: '身份证号',
                focusNode: logic.agentPersonIdNode,
                controller: logic.agentPersonIdController,
                maxLength: 18,
                regExp: RegExpUtil.idCard(),
                check: logic.check,
                showErr: () =>
                    !RegExpUtil.checkIdCard(logic.agentPersonIdController.text),
              ),
              SizedBox(
                height: 20,
              ),
              Container(
                margin: EdgeInsets.only(left: 20),
                child: Text(
                  '法人信息',
                  style: TextStyle(fontSize: 14, color: Color(0xff5B6F80)),
                ),
              ),
              SizedBox(
                height: 10,
              ),
              FormInput(
                isRequired: true,
                title: '姓名',
                focusNode: logic.legalPersonNode,
                controller: logic.legalPersonController,
                maxLength: 10,
                check: logic.check,
              ),
              FormInput(
                isRequired: true,
                title: '手机号',
                focusNode: logic.legalPersonPhoneNode,
                controller: logic.legalPersonPhoneController,
                maxLength: 11,
                inputType: TextInputType.numberWithOptions(decimal: false),
                regExp: RegExpUtil.num(),
                check: logic.check,
                showErr: () =>
                    logic.legalPersonPhoneController.text.length != 11,
              ),
              FormInput(
                isRequired: true,
                title: '身份证号',
                focusNode: logic.legalPersonIdNode,
                controller: logic.legalPersonIdController,
                maxLength: 18,
                regExp: RegExpUtil.idCard(),
                check: logic.check,
                showErr: () =>
                    !RegExpUtil.checkIdCard(logic.legalPersonIdController.text),
              ),
              SizedBox(
                height: 100,
              ),
              ButtonPublicRadius(
                  text: '确认并认证',
                  onPress: () {
                    _showConfirmDialog();
                  }),
              SizedBox(
                height: 20,
              )
            ],
          ),
        );
      }),
    );
  }

  void _showConfirmDialog() {
    Get.dialog(Dialog(
      child: Container(
        padding: EdgeInsets.symmetric(horizontal: 30),
        decoration: BoxDecoration(
            color: Colors.white, borderRadius: BorderRadius.circular(10)),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            SizedBox(
              height: 30,
            ),
            Container(
              padding: EdgeInsets.all(5),
              child: Text(
                '您好！根据《中华人民共和国网络安全法》和其他相关法律、法规的规定，办理企业认证需要国家指定机构授权。如确认办理，将跳转到第三方平台进行授权。请在认证前确认您的企业信息！',
                style: TextStyle(color: Color(0xff909399), fontSize: 15),
              ),
            ),
            SizedBox(
              height: 25,
            ),
            Row(
              children: [
                Expanded(
                  child: ButtonPublicRadiusOutline(
                    text: '取消认证',
                    onPress: () {
                      Get.back();
                    },
                    margin: EdgeInsets.all(0),
                  ),
                ),
                SizedBox(
                  width: 15,
                ),
                Expanded(
                  child: ButtonPublicRadius(
                    text: '立即确认',
                    onPress: () {
                      Get.back();
                      logic.confirm();
                    },
                    margin: EdgeInsets.all(0),
                  ),
                )
              ],
            ),
            SizedBox(
              height: 20,
            )
          ],
        ),
      ),
    ));
  }
}
