import 'package:account_center/account_center.dart';
import 'package:account_center/api/base_model.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/common/utils/progress_loading.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/comapny_http.dart';
import 'package:account_center/page/enterprise/certification/certification_tip/certification_status.dart';
import 'package:account_center/page/web/custom_webview.dart';

class CertificationTipLogic extends GetxController {
  CertificationStatus? certificationStatus;
  String signatureStatus = '';
  var data = {};
  @override
  void onInit() {
    _requestCertificationMessage();
    _requestSignatureData();
    super.onInit();
  }

  void toSignature() {
    Get.toNamed(RouteConfig.signatureResult);
  }

  /// 获取认证信息
  void _requestCertificationMessage() {
    CompanyHttps.getCompanyInfo(
      getCompanyNo(),
      onSuccess: (data) {
        var status = data['realNameFlowStatus'];
        if (status == 0) {
          certificationStatus = CertificationStatus.first;
        } else if (status == 1 || status == 2 || status == 3 || status == 5) {
          certificationStatus = CertificationStatus.doing;
        } else if (status == 4) {
          certificationStatus = CertificationStatus.success;
        }
        update();
      },
    );
  }

  void reContinue() {
    showLoading();
    CompanyHttps.getCompanyInfo(
      getCompanyNo(),
      onSuccess: (data) {
        var status = data['realNameFlowStatus'];
        if (status == 0) {
          certificationStatus = CertificationStatus.first;
        } else if (status == 1 || status == 2 || status == 3 || status == 5) {
          certificationStatus = CertificationStatus.doing;
        } else if (status == 4) {
          certificationStatus = CertificationStatus.success;
        }
        update();
        if (certificationStatus != CertificationStatus.doing) {
          Get.toNamed(RouteConfig.enterpriseMessageCertificationPage);
          return;
        }
        fetch(Method.get, url: HttpApi.getLoginEsignCompanyIdentifyData,
            onSuccess: (response) {
          fetch(Method.post,
              url: HttpApi.saveEsignCompanyIdentifyFlow,
              params: response, onSuccess: (response1) {
            response1 as Map<String, dynamic>;
            if (response1['authShortUrl'] != null) {
              // WebUtil.launchInBrowser(
              //   response1['authShortUrl'],
              // );
              Get.to(CustomWebView(url: response1['authShortUrl']));
            }
            dismissLoading();
          }, onError: (code, message) {
            dismissLoading();
          });
        }, onError: (code, message) {
          dismissLoading();
        });
      },
    );
  }

  void _requestSignatureData() {
    fetch(Method.get, url: HttpApi.getLoginEsignCompanySealAndStatus,
        onSuccess: (response) {
      var status = response['sealShowStatus'];
      signatureStatus = status == 3 ? '企业签章' : '申请签章';
      update();
    });
  }
}
