import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import '../company_home/widget/company_nav.dart';
import 'stamp_use_history_logic.dart';
import 'widget/stamp_history_item.dart';

class StampUseHistoryView extends GetView<StampUseHistoryLogic> {
  const StampUseHistoryView({super.key});

  StampUseHistoryLogic get _logic => controller;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CompanyManageNav.createNav('签章使用记录',
          action: GestureTapWidget(
            onTap: _logic.showScreenAlert,
            child: Container(
              width: 50,
              margin: const EdgeInsets.only(right: 15),
              alignment: Alignment.centerRight,
              color: Colors.white,
              child: Icon(
                Icons.filter_alt,
                size: 20,
                color: Color(0xff000000),
              ),
            ),
          )),
      body: GetBuilder(
          init: _logic,
          builder: ((controller) {
            return MySubListViewPublic(
              controller: _logic.controller,
              padding: EdgeInsets.all(10),
              itemBuilder: ((context, index, item) {
                return StampHistoryItem(
                  item: item,
                );
              }),
              requestData: _logic.requestData,
            );
          })),
    );
  }
}
