import 'package:account_center/account_center.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/button_public_radius_outline.dart';
import 'package:account_center/widget/form/form_show.dart';
import 'package:flutter/material.dart';

class AgentConfirmDialog extends StatefulWidget {
  final dynamic data;
  const AgentConfirmDialog({
    super.key,
    this.data,
  });

  @override
  State<AgentConfirmDialog> createState() => _AgentConfirmDialogState();
}

class _AgentConfirmDialogState extends State<AgentConfirmDialog> {
  @override
  Widget build(BuildContext context) {
    return Dialog(
      child: Container(
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color: Colors.white,
        ),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          children: [
            SizedBox(
              height: 20,
            ),
            Container(
              padding: const EdgeInsets.symmetric(horizontal: 20),
              child: Text(
                '检测到当前企业在e签宝的代理人与您提交的代理人信息不一致，无法直接完成授权',
                style: TextStyle(fontSize: 16, color: Colors.redAccent),
              ),
            ),
            SizedBox(
              height: 5,
            ),
            Text(
              'e签宝当前代理人信息：',
              style: TextStyle(fontSize: 14),
            ),
            FormShow(title: '代理人', content: widget.data['esignAgentName']),
            FormShow(title: '手机号', content: widget.data['esignAgentMobile']),
            SizedBox(height: 10),
            Text(
              '您可以通过以下方式完成授权操',
              style: TextStyle(fontSize: 13, color: Colors.grey),
            ),
            ButtonPublicRadiusOutline(
                text: '前往官网修改代理人信息',
                margin: EdgeInsets.only(left: 20, right: 20),
                onPress: () {
                  Get.back(result: AgentHandIntent.goOfficialWebsite);
                }),
            SizedBox(
              height: 10,
            ),
            ButtonPublicRadius(
              text: '获取链接，发送给代理人完成授权',
              margin: EdgeInsets.only(left: 20, right: 20),
              onPress: () {
                Get.back(result: AgentHandIntent.copyLink);
              },
            ),
            SizedBox(height: 20),
          ],
        ),
      ),
    );
  }
}

enum AgentHandIntent {
  // 去官网修改代理人信息
  goOfficialWebsite,
  // 复制链接，发送给代理人完成授权
  copyLink,
}
