import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

import '../company_auth/widget/common/company_define.dart';
import '../company_auth/widget/common/input_field.dart';
import '../company_home/widget/company_nav.dart';
import 'company_auth_result_logic.dart';

class CompanyAuthResultView extends GetView<CompanyAuthResultLogic> {
  const CompanyAuthResultView({super.key});

  CompanyAuthResultLogic get _logic => controller;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CompanyManageNav.createNoBackNav(_logic.title),
      body: Container(
        margin: const EdgeInsets.only(top: 10),
        padding: const EdgeInsets.all(20),
        color: Colors.white,
        width: double.infinity,
        child: GetBuilder(
            init: _logic,
            builder: ((controller) {
              if (_logic.authAndSignStatus == AuthAndSignStatus.normal) {
                return Container();
              }
              return Column(
                mainAxisSize: MainAxisSize.min,
                children: [
                  ImageLoad.loadAssertImage(
                    _logic.iconName,
                    width: 52,
                    height: 52,
                  ),
                  vGap20,
                  Text(
                    _logic.resultString,
                    style: TextStyle(
                      color: Color(0xff171A1D),
                      fontSize: 17,
                      fontWeight: FontWeight.w400,
                    ),
                  ),
                  Visibility(
                    visible: _logic.errorMsg.isNotEmpty,
                    child: Padding(
                      padding: const EdgeInsets.only(top: 8),
                      child: Text(
                        _logic.errorMsg,
                        style: TextStyle(
                            color: Color(0xff86909C),
                            fontSize: 13,
                            fontWeight: FontWeight.w400),
                      ),
                    ),
                  ),
                  vGap20,
                  GestureTapWidget(
                    onTap: _logic.buttonAction,
                    child: Container(
                      alignment: Alignment.center,
                      height: 50,
                      margin: EdgeInsets.symmetric(horizontal: 5),
                      decoration: BoxDecoration(
                        color: StyleParams.themeColor,
                        borderRadius: BorderRadius.circular(8),
                      ),
                      child: Text(
                        _logic.btnTitle,
                        style: const TextStyle(
                          color: Colors.white,
                          fontSize: 15,
                          fontWeight: FontWeight.w600,
                        ),
                      ),
                    ),
                  ),
                  vGap20,
                  Visibility(
                    visible: _logic.isAuth,
                    child: Container(
                      padding: const EdgeInsets.symmetric(horizontal: 15),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(4),
                        color: Color(0xffF3F6FA),
                      ),
                      child: Column(
                        children: [
                          InputField(
                            title: '企业名称',
                            value: _logic.companyName,
                            enabled: false,
                          ),
                          InputField(
                            title: '法人姓名',
                            value: _logic.legalName,
                            enabled: false,
                          ),
                          InputField(
                            title: '对公账户',
                            value: _logic.bankNumber,
                            enabled: false,
                          ),
                        ],
                      ),
                    ),
                  ),
                ],
              );
            })),
      ),
    );
  }
}
