import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

class InputField extends StatefulWidget {
  final String title;
  final String? value;
  final String? placeholder;
  final Widget? rightWidget;
  final ValueChanged<String>? onChanged;
  final bool enabled;
  final int maxLength;
  final int minLength;
  final String? error;
  final TextInputType? keyboardType;
  final GestureTapCallback? tapCallback;
  final List<TextInputFormatter>? inputFormatters;
  const InputField({
    super.key,
    required this.title,
    this.placeholder,
    this.error,
    this.onChanged,
    this.value,
    this.enabled = true,
    this.maxLength = 5000,
    this.minLength = 0,
    this.tapCallback,
    this.rightWidget,
    this.keyboardType,
    this.inputFormatters,
  });

  @override
  State<StatefulWidget> createState() {
    return _InputField();
  }
}

class _InputField extends State<InputField> {
  String? _error;

  final TextEditingController _controller = TextEditingController();

  String? get showError {
    if (widget.error != null && widget.error?.isNotEmpty == true) {
      return widget.error!;
    }
    return _error;
  }

  @override
  Widget build(BuildContext context) {
    String inputStr = widget.value ?? '';

    /// 因为Android中光标会错位，所以纠正光标位置
    _controller.value = TextEditingValue(
        text: inputStr,
        selection: TextSelection.fromPosition(TextPosition(
            affinity: TextAffinity.downstream, offset: inputStr.length)));

    return Container(
      // height: 55,
      decoration: BoxDecoration(
        border: Border(
          bottom: BorderSide(color: Color(0xffE1E1E2), width: 0.5),
        ),
      ),
      child: Row(
        children: [
          SizedBox(
            width: 85,
            child: Text(
              widget.title,
              style: TextStyle(
                color: Color(0xff171A1D),
                fontSize: 16,
                fontWeight: FontWeight.w400,
              ),
            ),
          ),
          Expanded(
            child: GestureTapWidget(
              onTap: widget.tapCallback,
              child: TextField(
                controller: _controller,
                enabled: widget.enabled,
                maxLength: widget.maxLength,
                keyboardType: widget.keyboardType,
                maxLines: null,
                style: TextStyle(
                    color: Color(0xff171A1D),
                    fontSize: 14,
                    fontWeight: FontWeight.w400),
                onChanged: (string) {
                  if (string.length < widget.minLength ||
                      string.length > widget.maxLength) {
                    _error = '请输入正确的${widget.title}';
                  } else {
                    _error = null;
                  }
                  setState(() {});
                  if (widget.onChanged != null) widget.onChanged!(string);
                },
                inputFormatters: widget.inputFormatters,
                decoration: InputDecoration(
                  contentPadding: EdgeInsets.only(bottom: 1),
                  hintText: widget.placeholder ?? '请输入${widget.title}',
                  hintStyle: TextStyle(
                      color: Color(0xffCDD0D6),
                      fontSize: 14,
                      fontWeight: FontWeight.w400),
                  focusedBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colors.white.withAlpha(0)),
                  ),
                  enabledBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colors.white.withAlpha(0)),
                  ),
                  disabledBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colors.white.withAlpha(0)),
                  ),
                  counterText: '',
                  errorText: showError,
                  focusedErrorBorder: UnderlineInputBorder(
                    borderSide: BorderSide(color: Colors.white.withAlpha(0)),
                  ),
                  errorBorder: UnderlineInputBorder(
                    borderSide:
                        BorderSide(color: Colors.red.withAlpha(1), width: 1),
                  ),
                  errorStyle: TextStyle(
                      color: Color(0xffFF3141),
                      fontSize: 13,
                      fontWeight: FontWeight.w400),
                ),
              ),
            ),
          ),
          if (widget.rightWidget != null) widget.rightWidget!,
        ],
      ),
    );
  }
}
