import 'dart:async';

import 'package:account_center/account_center.dart';
import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/common/utils/alert_util.dart';
import 'package:flutter/material.dart';

import '../../model/agent_info_model.dart';
import '../common/attribute_string.dart';
import '../common/comapny_http.dart';
import '../common/company_define.dart';
import '../common/input_field.dart';

class AgentInfoWidget extends StatefulWidget {
  final AgentInfoModel? model;
  final ValueChanged<String>? onChanged;
  const AgentInfoWidget({
    super.key,
    this.model,
    this.onChanged,
  });

  @override
  State<StatefulWidget> createState() {
    return _AgentInfoWidget();
  }
}

class _AgentInfoWidget extends State<AgentInfoWidget> {
  int _count = 60;
  Timer? _timer;

  @override
  void dispose() {
    _timer?.cancel();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.only(left: 20, right: 20, top: 20, bottom: 10),
      color: Colors.white,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          CLXAttributeString()
              .add('请确认', normalStyle)
              .add('代理人', lightStyle)
              .add('信息', normalStyle)
              .richText,
          vGap10,
          InputField(
            title: '姓名',
            enabled: false,
            value: widget.model?.name,
          ),
          InputField(
            title: '身份证号',
            value: widget.model?.idCard,
            enabled: false,
          ),
          InputField(
            title: '手机号',
            value: widget.model?.phone,
            enabled: false,
            // rightWidget: GestureTapWidget(
            //   onTap: _sendSms,
            //   child: Text(
            //     btnTitle,
            //     style: TextStyle(
            //         color: StyleParams.themeColor,
            //         fontSize: 14,
            //         fontWeight: FontWeight.w500),
            //   ),
            // ),
          ),
          // InputField(
          //   title: '验证码',
          //   value: widget.model?.sms,
          //   maxLength: 6,
          //   minLength: 6,
          //   keyboardType: TextInputType.number,
          //   inputFormatters: [
          //     FilteringTextInputFormatter.digitsOnly,
          //   ],
          //   onChanged: (value) {
          //     if (widget.onChanged != null) {
          //       widget.onChanged!(value);
          //     }
          //   },
          // )
        ],
      ),
    );
  }

  String get btnTitle {
    if (_count == 60) {
      return '获取验证码';
    } else {
      return '重新获取(${_count}s)';
    }
  }

  /// 发送验证码
  void _sendSms() {
    if (getTXTString(widget.model?.phone).isEmpty) {
      AlertUtil.showCenterToast('代理人人手机号为空，请先设置手机号');
      return;
    }
    if (_count < 60) {
      return;
    }
    CompanyHttps.sendCompanyRealNameCaptcha(
      widget.model?.phone ?? '',
      getCompanyNo() ?? '',
      onSuccess: (data) {
        _timer = Timer.periodic(const Duration(seconds: 1), (timer) {
          _count--;
          if (_count == 0) {
            _count = 60;
            _timer?.cancel();
          }
          setState(() {});
        });
      },
    );
  }
}
