import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:flutter/material.dart';

import '../../company_auth_logic.dart';
import '../common/attribute_string.dart';
import '../common/company_define.dart';
import '../common/input_field.dart';

class ConfirmBankInfo extends StatelessWidget {
  final CompanyAuthLogic logic;
  const ConfirmBankInfo({super.key, required this.logic});

  @override
  Widget build(BuildContext context) {
    return GetBuilder(
      init: logic,
      builder: ((controller) {
        return Column(
          children: [
            vGap10,
            Container(
              padding: const EdgeInsets.only(
                  left: 20, right: 20, top: 20, bottom: 10),
              color: Colors.white,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  if (logic.bankInfoModel.transferStatus == 0)
                    Container(
                      margin: const EdgeInsets.only(bottom: 20),
                      width: double.infinity,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(8),
                      ),
                      child: Text(
                        '验证金额打款中，请及时关注银行收款信息',
                        style: TextStyle(
                          color: StyleParams.themeColor,
                          fontSize: 18,
                          fontWeight: FontWeight.w600,
                        ),
                      ),
                    ),
                  CLXAttributeString()
                      .add('请确认企业', normalStyle)
                      .add('对公账户', lightStyle)
                      .add('信息', normalStyle)
                      .richText,
                  vGap10,
                  InputField(
                    title: '开户行',
                    value: logic.bankInfoModel.bankName,
                    enabled: false,
                  ),
                  InputField(
                    title: '银行卡号',
                    value: logic.bankInfoModel.cardNumber,
                    enabled: false,
                  ),
                ],
              ),
            ),
            vGap50,
            GestureTapWidget(
              onTap: logic.uploadBusinessInfo,
              child: Container(
                alignment: Alignment.center,
                height: 50,
                margin: EdgeInsets.only(
                  left: 25,
                  right: 25,
                  bottom: MediaQuery.of(context).padding.bottom + 15,
                ),
                decoration: BoxDecoration(
                  color: StyleParams.themeColor,
                  borderRadius: BorderRadius.circular(8),
                ),
                child: Text(
                  btnTitle,
                  style: TextStyle(
                      color: Colors.white,
                      fontSize: 15,
                      fontWeight: FontWeight.w600),
                ),
              ),
            ),
          ],
        );
      }),
    );
  }

  String get btnTitle {
    if (logic.bankInfoModel.transferStatus != 2) {
      return '我已收到款项';
    } else {
      return '修改信息';
    }
  }
}
