import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/button_public_radius_outline.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

class VerifyConfirm extends StatelessWidget {
  final void Function() action;
  const VerifyConfirm({super.key, required this.action});

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: const BoxDecoration(
        gradient: LinearGradient(
          begin: Alignment.topCenter,
          end: Alignment.bottomCenter,
          colors: [
            Color(0xFFF8E7CF),
            Color(0xFFF3F5F8),
          ],
          stops: [0.0, 0.3],
        ),
      ),
      padding: const EdgeInsets.symmetric(horizontal: 10),
      child: Column(
        children: [
          const SizedBox(height: 60),
          Align(
            alignment: Alignment.centerLeft,
            child: GestureDetector(
              onTap: () {
                Get.back();
              },
              child: const Icon(
                Icons.close_rounded,
                color: Colors.black,
                size: 28,
              ),
            ),
          ),
          const SizedBox(height: 20),
          Row(
            children: [
              const Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Row(
                    children: [
                      Text(
                        '用户体系',
                        style: TextStyle(
                          fontSize: 16,
                          fontWeight: FontWeight.w700,
                          color: Color(0xFF333C4C),
                        ),
                      ),
                      SizedBox(
                        width: 6,
                      ),
                      Text(
                        '申请使用',
                        style: TextStyle(
                          fontSize: 16,
                          fontWeight: FontWeight.w700,
                          color: Color(0xFFE28C22),
                        ),
                      ),
                    ],
                  ),
                  SizedBox(
                    height: 10,
                  ),
                  Text(
                    '获取您企业的以下信息：',
                    style: TextStyle(
                      fontSize: 14,
                      fontWeight: FontWeight.w400,
                      color: Color(0xFF86909C),
                    ),
                  )
                ],
              )
            ],
          ),
          const SizedBox(height: 20),
          _contentRow('企业e签宝相关授权'),
          _contentRow('签章信息'),
          _contentRow('合同签署权限'),
          const Spacer(),
          Row(
            children: [
              const SizedBox(width: 10),
              ButtonPublicRadiusOutline(
                text: '拒绝',
                width: 80,
                margin: const EdgeInsets.only(right: 10),
                onPress: () {
                  Navigator.pop(context);
                },
              ),
              Expanded(
                  child: ButtonPublicRadius(
                text: '同意授权',
                onPress: action,
                margin: const EdgeInsets.only(left: 0),
              )),
              const SizedBox(width: 10),
            ],
          ),
          const SizedBox(height: 15)
        ],
      ),
    );
  }

  Widget _contentRow(String content) {
    return Container(
      margin: const EdgeInsets.only(top: 20),
      child: Row(
        children: [
          ImageLoad.loadAssertImage(
            'check_circle',
            width: 20,
          ),
          const SizedBox(width: 10),
          Text(
            content,
            style: const TextStyle(
              color: Color(0xFF344254),
              fontSize: 16,
            ),
          )
        ],
      ),
    );
  }
}
