import 'package:account_center/account_center.dart';

class BusinessInfoModel {
  /// 公司地址
  String? businessAddress;

  /// 法人姓名
  String? legalName;

  /// 注册资本
  String? registeredCapital;

  /// 经营范围
  String? businessScope;

  /// 营业执照地址
  String? companyBusinessImg;

  /// 企业名称
  String? companyName;

  /// 企业编码
  String? companyNo;

  /// 信用代码
  String? groupCode;

  /// 企业注册日期
  String? registrationDate;

  /// 营业有效期-生效时间
  String? startTime;

  /// 营业有效期-失效时间
  String? endTime;

  /// 是否长期有效
  bool isIndefinite = false;

  /// 有效期
  String? get validityTime {
    if (isIndefinite) {
      return '长期有效';
    }
    if (startTime?.isTimeStr == true && endTime?.isTimeStr == true) {
      return '$startTime 至 $endTime';
    }
    return null;
  }

  Map<String, dynamic> toJson() {
    return {
      'businessAddress': businessAddress,
      'businessEndDate': endTime,
      'businessLongTermFlag': isIndefinite ? 1 : 0,
      'businessScope': businessScope,
      'businessStartDate': startTime,
      'companyBusinessImg': companyBusinessImg,
      'companyName': companyName,
      'groupCode': groupCode,
      'legalName': legalName,
      'registeredCapital': registeredCapital,
      'registrationDate': registrationDate,
    };
  }

  fromJson(Map<String, dynamic>? json) {
    companyBusinessImg = json?['companyBusinessImg'];
    businessAddress = json?['companyAddress'];
    companyName = json?['companyName'];
    companyNo = json?['companyNo'];
    groupCode = json?['companyGroupCode'];
    registrationDate = json?['createTime'];
    startTime = json?['businessStartDate'];
    endTime = json?['businessEndDate'];
    isIndefinite = json?['businessLongTermFlag'] == 1;
    legalName = json?['legalName'];
  }

  /// 营业执照信息是否有效
  bool get isValid {
    if (getTXTString(companyName).isEmpty == true) {
      return false;
    }
    if (getTXTString(companyName).length > 128 ||
        getTXTString(companyName).length < 2) {
      return false;
    }
    if (getTXTString(groupCode).isEmpty == true) {
      return false;
    }
    if (getTXTString(groupCode).length != 18) {
      return false;
    }

    if (getTXTString(registrationDate).isEmpty == true) {
      return false;
    }

    if (getTXTString(registeredCapital).isEmpty) {
      return false;
    }
    return true;
  }

  /// 错误信息展示
  String get errorMsg {
    if (getTXTString(companyName).isEmpty == true) {
      return '企业名称不能为空';
    }
    if (getTXTString(companyName).length > 128 ||
        getTXTString(companyName).length < 2) {
      return '企业名称长度不合规';
    }
    if (getTXTString(groupCode).isEmpty == true) {
      return '社会统一信用代码不能为空';
    }
    if (getTXTString(groupCode).length != 18) {
      return '社会统一信用代码不合规';
    }

    if (getTXTString(registrationDate).isEmpty == true) {
      return '企业创建时间不能为空';
    }

    if (getTXTString(registeredCapital).isEmpty) {
      return '注册资本不能为空';
    }
    return '';
  }
}
