import 'package:account_center/account_center.dart';

class BankInfoModel {
  /// 总行名称
  String? bank;

  /// 银行联行号
  String? cnapsCode;

  /// 省份
  String? province;

  /// 城市
  String? city;

  /// 卡号
  String? cardNumber;

  /// 支行名称
  String? bankName;

  /// 打款状态 0-打款中; 1-打款成功; 2-打款失败
  int transferStatus = 0;

  /// 打款失败原因
  String? transferFailMessage;

  /// 打款开户名称
  String? payeeName;

  /// 收款公司
  String? companyName;

  /// 过期时间
  String? expiredTime;

  /// 是否允许提交
  bool get isValid {
    if (getTXTString(bank).isEmpty) {
      return false;
    }
    if (getTXTString(cardNumber).isEmpty) {
      return false;
    }
    if (getTXTString(cardNumber).length < 12 ||
        getTXTString(cardNumber).length > 25) {
      return false;
    }
    return true;
  }

  String get errorMsg {
    if (getTXTString(bank).isEmpty) {
      return '请选择开户行';
    }
    if (getTXTString(cardNumber).isEmpty) {
      return '请填写银行卡号';
    }
    if (getTXTString(cardNumber).length < 12 ||
        getTXTString(cardNumber).length > 25) {
      return '银行卡号不合规';
    }
    return '';
  }

  Map<String, dynamic> toJson() {
    return {
      'bank': bank,
      'cnapsCode': cnapsCode,
      'province': province,
      'city': city,
      'cardNumber': cardNumber,
      'bankName': bankName,
    };
  }

  fromJson(Map<String, dynamic>? json) {
    bank = json?['bank'];
    cnapsCode = json?['cnapsCode'];
    province = json?['province'];
    city = json?['city'];
    cardNumber = json?['cardNumber'];
    bankName = json?['bankName'];
  }
}
