import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_company/company_home/widget/company_nav.dart';
import 'package:flutter/material.dart';

import 'company_auth_logic.dart';
import 'widget/file_business_info/upload_info.dart';

class CompanyAuthView extends GetView<CompanyAuthLogic> {
  const CompanyAuthView({super.key});

  CompanyAuthLogic get _logic => controller;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: CompanyManageNav.createNav('企业认证'),
      body: SingleChildScrollView(
        controller: _logic.controller,
        physics: ClampingScrollPhysics(),
        child: GetBuilder(
            init: _logic,
            builder: (controller) {
              return Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  // TopStepWidget(logic: _logic),

                  if (_logic.currStep == 0) UploadInfoWidget(logic: _logic),
                  // if (_logic.currStep == -1) AgentInfo(logic: _logic),
                  // if (_logic.currStep == 1 || _logic.currStep == 5)
                  //   WriteAccountInfo(logic: _logic),
                  // if (_logic.currStep == 2) ConfirmBankInfo(logic: _logic),
                  // if (_logic.currStep == 3) PayInfo(logic: _logic),
                ],
              );
            }),
      ),
    );
  }
}
