import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/pdf_preview.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'sign_history_logic.dart';

class SignHistoryView extends GetView<SignHistoryLogic> {
  const SignHistoryView({super.key});

  SignHistoryLogic get logic => controller;

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar(
        '签订记录',
        actions: [
          InkWell(
            onTap: logic.showFilter,
            child: Container(
              padding: EdgeInsets.only(right: 10),
              child: ImageLoad.loadAssertImage(
                'filter_ic',
                width: 24,
              ),
            ),
          )
        ],
      ),
      body: MyListViewPublic(
        itemBuilder: _buildItem,
        requestData: logic.requestData,
        controller: logic.listController,
      ),
    );
  }

  Widget _buildItem(BuildContext context, int index, item) {
    return Container(
      padding: EdgeInsets.all(15),
      margin: EdgeInsets.only(
        left: 10,
        top: 10,
        right: 10,
      ),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        color: Colors.white,
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            '使用时间：${item?['signTime']}',
            style: TextStyle(color: Color(0xFF344254), fontSize: 13),
          ),
          SizedBox(
            height: 12,
          ),
          Container(
            width: double.infinity,
            color: Color(0xFFF4F8FD),
            padding: EdgeInsets.all(10),
            child: Column(
              children: [
                Row(
                  children: [
                    Expanded(child: _contentRow('产品', item['productName'])),
                    Expanded(child: _contentRow('文件', item['templateName']))
                  ],
                ),
                SizedBox(height: 5),
                Row(
                  children: [
                    Expanded(child: _contentRow('编号', item['relationNo'])),
                    Expanded(
                      child: _contentRow(
                        '合同',
                        null,
                        end: InkWell(
                          onTap: () {
                            Get.to(PdfPreview(ossDomain + item['signUrl']));
                          },
                          child: Text(
                            '合同预览',
                            style: TextStyle(
                              color: Color(0xFF1F59EF),
                              fontSize: 13,
                              fontWeight: FontWeight.w500,
                            ),
                          ),
                        ),
                      ),
                    )
                  ],
                ),
              ],
            ),
          )
        ],
      ),
    );
  }

  Widget _contentRow(String title, dynamic content, {Widget? end}) {
    return Row(
      children: [
        Text(
          title,
          style: TextStyle(
            color: Color(0xFF687582),
            fontSize: 12,
          ),
        ),
        SizedBox(
          width: 10,
        ),
        Expanded(
          child: end ??
              Text(
                getTXTString(content),
                style: TextStyle(
                  color: Color(0xFF344254),
                  fontSize: 13,
                  fontWeight: FontWeight.w500,
                ),
              ),
        )
      ],
    );
  }
}
