import 'package:account_center/common/utils/customized_text_input_formatter.dart';
import 'package:account_center/style/style_params.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/clear_text.dart';
import 'package:account_center/widget/hint_text.dart';
import 'package:account_center/widget/send_v_code.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'real_name_logic.dart';

class RealNamePage extends StatelessWidget {
  final logic = Get.find<RealNameLogic>();
  final state = Get.find<RealNameLogic>().state;

  RealNamePage({super.key});

  final textStyle1 = TextStyle(
      fontSize: 24, color: Color(0xFF344254), fontWeight: FontWeight.w500);
  final textStyle2 = TextStyle(fontSize: 16, color: Color(0xFF687582));

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      backgroundColor: Colors.white,
      appBar: MyAppBar("实名认证"),
      children: [
        vGap30,
        Row(
          children: [
            hGap60,
            Text(
              "实名认证",
              style: textStyle1,
            ),
          ],
        ),
        vGap5,
        Row(
          children: [
            hGap60,
            Text(
              "认证个人身份信息",
              style: TextStyle(fontSize: 14, color: Color(0xFFA3A8B2)),
            ),
          ],
        ),
        vGap25,
        Container(
          padding: EdgeInsets.only(left: 40, right: 40),
          child: Column(
            children: [
              Container(
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(8),
                  color: Color(0xFFF7F8FA),
                ),
                child: Row(
                  children: [
                    hGap15,
                    Text(
                      "姓名",
                      style: textStyle2,
                    ),
                    hGap20,
                    Expanded(
                      child: TextField(
                        focusNode: state.nameFocusNode,
                        controller: state.nameController,
                        cursorColor: StyleParams.themeColor,
                        decoration: InputDecoration(
                          border: InputBorder.none,
                          hintText: '请输入姓名',
                          hintStyle: TextStyle(
                              color: Colors.grey.shade400,
                              fontSize: 14.0,
                              fontWeight: FontWeight.w400),
                        ),
                        style: TextStyle(
                          fontSize: 14.0,
                        ),
                        inputFormatters: [
                          /// 限制输入长度
                          CustomizedLengthTextInputFormatter(6),

                          /// 只能输入汉字或者字母或数字
                          CustomizedTextInputFormatter(
                            filterPattern: RegExp("[\u4e00-\u9fa5]"),
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
              vGap15,
              Container(
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(8),
                  color: Color(0xFFF7F8FA),
                ),
                child: Row(
                  children: [
                    hGap15,
                    Text(
                      "身份证号",
                      style: textStyle2,
                    ),
                    hGap20,
                    Expanded(
                      child: ClearText(
                        state.idCardController,
                        "请输入",
                        maxLength: 18,
                        hintSize: 14.0,
                        regExp: "[xX]|[0-9]",
                        inputType: TextInputType.phone,
                        focusNode: state.idCardFocusNode,
                      ),
                    ),
                  ],
                ),
              ),
              vGap15,
              Container(
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(8),
                  color: Color(0xFFF7F8FA),
                ),
                child: Row(
                  children: [
                    hGap15,
                    Text(
                      "手机号",
                      style: textStyle2,
                    ),
                    hGap20,
                    Text(
                      "15701570157",
                      style: textStyle2,
                    ),
                    hGap5,
                    SendVCode('', () => "15701570157"),
                  ],
                ),
              ),
              vGap15,
              Container(
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(8),
                  color: Color(0xFFF7F8FA),
                ),
                child: Row(
                  children: [
                    hGap15,
                    Text(
                      "验证码",
                      style: textStyle2,
                    ),
                    hGap20,
                    Expanded(
                      child: HintText(state.vCodeController, "请输入",
                          maxLength: 11, focusNode: state.vCodeFocusNode),
                    ),
                  ],
                ),
              ),
              vGap50,
              ButtonPublicRadius(
                margin: EdgeInsets.zero,
                text: "确定",
                onPress: () {},
              ),
            ],
          ),
        )
      ],
    );
  }
}
