import 'package:account_center/common/sp/sp_util.dart';
import 'package:account_center/page/account_center/widget/change_name_tip.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/clear_text.dart';
import 'package:account_center/widget/form/form_show.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';

import 'modify_name_logic.dart';

class ModifyNamePage extends StatelessWidget {
  final logic = Get.find<ModifyNameLogic>();
  final state = Get.find<ModifyNameLogic>().state;
  final textStyle1 = TextStyle(
      fontSize: 24, color: Color(0xFF344254), fontWeight: FontWeight.w500);
  final textStyle2 = TextStyle(fontSize: 16, color: Color(0xFF687582));

  ModifyNamePage({super.key});

  @override
  Widget build(BuildContext context) {
    return MyScaffold(
      appBar: MyAppBar("修改姓名"),
      children: logic.isReal ? real() : noReal(),
    );
  }

  List<Widget> real() => [
        SizedBox(
          height: 10,
        ),
        FormShow(
          title: '姓名',
          content: getUserName(),
        ),
        SizedBox(
          height: 10,
        ),
        ChangeNameTip(),
      ];

  List<Widget> noReal() {
    return [
      Container(
        margin: EdgeInsets.only(top: 10),
        decoration: BoxDecoration(
          color: Colors.white,
        ),
        child: Row(
          children: [
            hGap15,
            Text(
              "姓名",
              style: textStyle2,
            ),
            hGap20,
            Expanded(
              child: ClearText(
                state.nameController,
                "请输入",
                maxLength: 6,
                hintSize: 14.0,
                regExp: "[\u4e00-\u9fa5]",
                inputType: TextInputType.text,
                focusNode: state.nameFocusNode,
              ),
            ),
          ],
        ),
      ),
      vGap50,
      ButtonPublicRadius(
        text: "确定",
        onPress: logic.changeName,
      ),
    ];
  }
}
