import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/alert_util.dart';
import 'package:account_center/common/utils/bottom_dialog.dart';
import 'package:account_center/common/utils/date_picker.dart' as date_picker;
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/common/utils/reg_exp.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/profile_upload.dart';
import 'package:account_center/style/style_params.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/form/form_edit_clear.dart';
import 'package:account_center/widget/form/form_input.dart';
import 'package:account_center/widget/form/form_row.dart';
import 'package:account_center/widget/send_v_code.dart';
import 'package:flutter/material.dart';

import 'identity_user_id_card_logic.dart';

class IdentityUserIdCardPage extends StatelessWidget {
  final logic = Get.find<IdentityUserIdCardLogic>();
  final timeTextStyle = TextStyle(
    color: StyleParams.themeColor,
    fontSize: 16,
    fontWeight: FontWeight.w500,
  );

  IdentityUserIdCardPage({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: MyAppBar(
        '实名认证',
      ),
      body: GestureDetector(
          child: GetBuilder<IdentityUserIdCardLogic>(builder: (logic) {
        return SingleChildScrollView(
          child: Column(
            children: [
              Visibility(
                visible: logic.upIdentityErr || logic.downIdentityErr,
                child: Container(
                  width: double.infinity,
                  color: Color(0xFFFFF9ED),
                  padding: EdgeInsets.symmetric(horizontal: 12, vertical: 8),
                  child: Text(
                    '身份证照片识别失败，请重新上传图片或手动补全',
                    style: TextStyle(
                      fontSize: 14,
                      color: Color(0xFFFF8F1F),
                    ),
                  ),
                ),
              ),
              Container(
                color: Colors.white,
                padding: EdgeInsets.symmetric(horizontal: 25),
                width: double.infinity,
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    SizedBox(
                      height: 15,
                    ),
                    Text(
                      '上传身份证的正反面照片',
                      style: TextStyle(
                        fontSize: 16,
                        color: Color(0xff171A1D),
                      ),
                    ),
                    SizedBox(
                      height: 4,
                    ),
                    Text(
                      '请确保证件边框完整、字体清晰、亮度均匀',
                      style: TextStyle(
                        fontSize: 12,
                        color: Color(0xFFA4A8B1),
                      ),
                    ),
                    ProfileUpload(
                        title: '头像面',
                        detail: '上传身份证头像面',
                        backgroundImgName: 'id_card_on_upload',
                        size: Size(170, 110),
                        padding: EdgeInsets.only(
                            left: 15, top: 7, bottom: 7, right: 10),
                        placeholderPadding: EdgeInsets.all(5),
                        url: logic.urlIdCardUp,
                        error: logic.upIdentityMessage,
                        callBack: logic.selectIdCardUp),
                    ProfileUpload(
                      title: '国徽面',
                      detail: '上传身份证国徽面',
                      backgroundImgName: 'id_card_back_upload',
                      size: Size(170, 110),
                      padding: EdgeInsets.only(
                          left: 15, top: 7, bottom: 7, right: 10),
                      placeholderPadding: EdgeInsets.all(5),
                      url: logic.urlIdCardDown,
                      error: logic.downIdentityMessage,
                      callBack: logic.selectIdCardDown,
                    ),
                    SizedBox(
                      height: 10,
                    ),
                  ],
                ),
              ),
              SizedBox(
                height: 10,
              ),
              _cardMessage(),
            ],
          ),
        );
      })),
      bottomNavigationBar: SafeArea(
        child: Container(
          margin: EdgeInsets.only(top: 5),
          padding: EdgeInsets.only(top: 5),
          color: Colors.white,
          child: Column(
            mainAxisSize: MainAxisSize.min,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              // Container(
              //   margin: EdgeInsets.symmetric(horizontal: 25),
              //   child: RichText(
              //     text: TextSpan(
              //       children: [
              //         const TextSpan(
              //           text: '点击下方按钮代表您已同意',
              //           style: TextStyle(
              //             fontSize: 14,
              //             color: Color(0xFF171A1D),
              //           ),
              //         ),
              //         TextSpan(
              //             text: '《公司隐私协议》',
              //             style: TextStyle(
              //               fontSize: 14,
              //               color: StyleParams.themeColor,
              //             ),
              //             recognizer: TapGestureRecognizer()
              //               ..onTap = () {
              //                 Get.to(
              //                   SimpleWebView(
              //                       url:
              //                           'https://clx-prod.oss-cn-beijing.aliyuncs.com/dispatch/agreement/DDZX_RegistrationAgreement.html',
              //                       title: '用户协议'),
              //                 );
              //               }),
              //       ],
              //     ),
              //   ),
              // ),
              SizedBox(
                height: 13,
              ),
              ButtonPublicRadius(
                text: logic.isChangeDate ? '确定' : '完成人脸验证',
                onPress: () {
                  logic.confirm();
                },
                margin: EdgeInsets.symmetric(horizontal: 25),
              ),
              SizedBox(
                height: 10,
              ),
            ],
          ),
        ),
      ),
    );
  }

  Container _cardMessage() {
    return Container(
      color: Colors.white,
      width: double.infinity,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Container(
            padding: EdgeInsets.only(left: 25, top: 10, bottom: 5),
            child: Text(
              '请确认身份信息',
              style: TextStyle(
                fontSize: 16,
                fontWeight: FontWeight.w600,
                color: Colors.black,
              ),
            ),
          ),
          GestureDetector(
            onTap: logic.urlIdCardUp.isEmpty
                ? () {
                    AlertUtil.showCenterToast('请先上传身份证照片');
                  }
                : null,
            child: FormInput(
                title: '姓名',
                controller: logic.nameController,
                enabled: logic.urlIdCardUp.isNotEmpty,
                focusNode: logic.nameNode),
          ),
          GestureDetector(
            onTap: logic.urlIdCardUp.isEmpty
                ? () {
                    AlertUtil.showCenterToast('请先上传身份证照片');
                  }
                : null,
            child: FormInput(
              title: '身份证号',
              controller: logic.numberController,
              enabled: logic.urlIdCardUp.isNotEmpty,
              maxLength: 18,
              focusNode: logic.numberNode,
              regExp: '[0-9X]',
            ),
          ),
          FormRow(
            title: '有效期',
            child: _buildTimeRow(logic.startTimeController, '请选择身份证有效起始日期', () {
              Get.bottomSheet(
                date_picker.DatePicker(
                  title: '请选择',
                  maxValue: DateTime.now(),
                  type: date_picker.DateType.YMD,
                  (data) {
                    logic.startTimeController.text =
                        DateUtil.formatDate(data, format: 'yyyy-MM-dd');

                    logic.endTimeController.text = DateUtil.formatDate(
                        DateTime(data.year + 20, data.month, data.day),
                        format: 'yyyy-MM-dd');
                  },
                ),
              );
            }),
          ),
          FormRow(
            title: '',
            child: _buildTimeRow(logic.endTimeController, '请选择身份证有效结束日期', () {
              BottomDialog.showBottomDialog([
                ButtonItem(
                  title: '长期',
                  onClick: () {
                    logic.endTimeController.text = '长期';
                  },
                ),
                ButtonItem(
                  title: '选择日期',
                  onClick: () {
                    Get.bottomSheet(
                      date_picker.DatePicker(
                        title: '请选择',
                        minValue: DateTime.now(),
                        type: date_picker.DateType.YMD,
                        (data) {
                          logic.endTimeController.text =
                              DateUtil.formatDate(data, format: 'yyyy-MM-dd');
                        },
                      ),
                    );
                  },
                ),
              ]);
            }),
          ),
          FormRow(
            title: '手机号',
            vCap: 3,
            child: Row(
              children: [
                Expanded(
                  child: FormEditClear(
                    focusNode: logic.phoneNode,
                    controller: logic.phoneController,
                    enabled: false,
                  ),
                ),
                SendVCode(
                  '',
                  () {
                    return logic.phoneController.text;
                  },
                  onSend: logic.sendCode,
                )
              ],
            ),
          ),
          FormInput(
            title: '验证码',
            controller: logic.codeController,
            focusNode: logic.codeNode,
            regExp: RegExpUtil.num(),
            maxLength: 6,
            inputType: TextInputType.number,
            check: logic.check,
            getErrText: () {
              return logic.codeController.text.length == 6 ? null : '请输入正确的验证码';
            },
          ),
        ],
      ),
    );
  }

  Widget _buildTimeRow(
      TextEditingController controller, String hint, void Function()? onTap) {
    return GestureTapWidget(
      onTap: () {
        if (controller.text.isNotEmpty || logic.urlIdCardDown.isNotEmpty) {
          onTap?.call();
        } else {
          AlertUtil.showCenterToast('请先上传身份证图片');
        }
      },
      child: Row(
        children: [
          Expanded(
            child: TextField(
              enabled: false,
              controller: controller,
              maxLines: null,
              style: timeTextStyle,
              decoration: InputDecoration(
                hintText: hint,
                border: InputBorder.none,
                isDense: true,
                contentPadding: const EdgeInsets.all(0),
              ),
            ),
          ),
          Visibility(
              visible:
                  controller.text.isNotEmpty || logic.urlIdCardDown.isNotEmpty,
              child: Text(
                '修改',
                style: timeTextStyle,
              ))
        ],
      ),
    );
  }

  /// 默认身份证图片
  GestureTapWidget _defaultIdCard(
      void Function()? onTap, String defaultImage, String clickTitle) {
    return GestureTapWidget(
      onTap: onTap,
      child: Stack(
        children: [
          ImageLoad.loadAssertImage(defaultImage),
          Container(
            alignment: Alignment.center,
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: [
                ImageLoad.loadAssertImage('circle_add', width: 32, height: 32),
                SizedBox(
                  height: 8,
                ),
                Text(
                  clickTitle,
                  style: TextStyle(
                    fontSize: 14,
                    fontWeight: FontWeight.w600,
                    color: Color(0xFF344254),
                  ),
                )
              ],
            ),
          )
        ],
      ),
    );
  }

  Container _dashBorder(double borderSize,
      {double width = 206, double height = 135}) {
    return Container(
      width: width,
      height: height,
      alignment: Alignment.center,
      child: Stack(
        children: [
          Positioned(
            top: 0,
            left: 0,
            width: borderSize,
            height: borderSize,
            child: ImageLoad.loadAssetsSvg('topleft'),
          ),
          Positioned(
            top: 0,
            right: 0,
            width: borderSize,
            height: borderSize,
            child: ImageLoad.loadAssetsSvg('topright'),
          ),
          Positioned(
            bottom: 0,
            left: 0,
            width: borderSize,
            height: borderSize,
            child: ImageLoad.loadAssetsSvg('bottomleft'),
          ),
          Positioned(
            bottom: 0,
            right: 0,
            width: borderSize,
            height: borderSize,
            child: ImageLoad.loadAssetsSvg('bottomright'),
          ),
        ],
      ),
    );
  }
}
