import 'package:account_center/account_center.dart';
import 'package:account_center/page/account_center/account_info/account_info_logic.dart';
import 'package:account_center/page/account_center/widget/result_layout.dart';
import 'package:account_center/style/widget/edit_app_bar.dart';
import 'package:flutter/material.dart';

class ChangePhoneSuccess extends StatelessWidget {
  final bool isRealName;
  const ChangePhoneSuccess(this.isRealName, {super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: EditAppBar(
        showCancel: false,
        hideBackArrow: true,
        confirm: () {
          Get.back();
        },
        title: '修改手机号',
      ),
      body: ResultLayout(
        title: '修改成功',
        secondTitle:
            isRealName ? '您的实名认证状态已同步失效，请重新进行个人实名认证，否则可能影响您在本平台的使用。' : null,
        buttonText: isRealName ? '更新实名认证' : '完成',
        onTap: () {
          if (isRealName) {
            Get.offNamed(RouteConfig.identityUserIdCardPage);
            findOtherLogic<AccountInfoLogic>()?.onReady();
          } else {
            Get.back();
          }
        },
        icon: 'circle_success',
      ),
    );
  }
}
