import 'package:account_center/account_center.dart';
import 'package:account_center/style/widget/button_public_radius.dart';
import 'package:account_center/style/widget/my_app_bar.dart';
import 'package:account_center/widget/hint_text.dart';
import 'package:account_center/widget/send_v_code.dart';
import 'package:flutter/material.dart';

import 'change_phone_logic.dart';

class ChangePhonePage extends StatelessWidget {
  final logic = Get.find<ChangePhoneLogic>();

  final textStyle1 = TextStyle(
      fontSize: 24, color: Color(0xFF344254), fontWeight: FontWeight.w500);
  final textStyle2 = TextStyle(fontSize: 16, color: Color(0xFF687582));

  ChangePhonePage({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.white,
      appBar: MyAppBar("修改手机号"),
      body: Column(
        children: [
          vGap30,
          Row(
            children: [
              hGap60,
              Text(
                "修改手机号",
                style: textStyle1,
              ),
            ],
          ),
          vGap30,
          GetBuilder<ChangePhoneLogic>(builder: (logic) {
            return Container(
              padding: EdgeInsets.only(left: 40, right: 40),
              child: Column(
                children: [
                  _buildInput(
                    '新手机号',
                    '请输入新手机号',
                    logic.phoneController,
                    logic.phoneNode,
                    maxLength: 11,
                    keyboardType: TextInputType.phone,
                  ),
                  vGap15,
                  _buildInput(
                    "验证码",
                    "请输入",
                    logic.vCodeController,
                    logic.codeNode,
                    end: SendVCode(
                      'captchaUserMobile',
                      () => logic.phoneController.text,
                    ),
                    maxLength: 6,
                    showErr: logic.codeErr,
                    errText: logic.codeErrText,
                  ),
                ],
              ),
            );
          })
        ],
      ),
      bottomNavigationBar: SafeArea(
        child: ButtonPublicRadius(
          margin: EdgeInsets.only(bottom: 10, left: 15, right: 15),
          text: "确定",
          onPress: () {
            logic.changePhone();
          },
        ),
      ),
    );
  }

  Widget _buildInput(String title, String hint,
      TextEditingController controller, FocusNode focusNode,
      {Widget? end,
      bool isPass = false,
      int maxLength = 16,
      bool showErr = false,
      String errText = "error",
      TextInputType keyboardType = TextInputType.text}) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Container(
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(8),
            color: Color(0xFFF7F8FA),
            border: Border.all(
              color: showErr ? Color(0xFFE02020) : Color(0xFFF7F8FA),
              width: 1,
            ),
          ),
          padding: EdgeInsets.only(bottom: 2),
          child: Row(
            children: [
              hGap15,
              SizedBox(
                width: 80,
                child: Text(
                  title,
                  style: textStyle2,
                ),
              ),
              Expanded(
                child: HintText(
                  controller,
                  hint,
                  maxLength: maxLength,
                  focusNode: focusNode,
                  isPass: isPass,
                  keyboardType: keyboardType,
                ),
              ),
            ]..addIf(end != null, end ?? Container()),
          ),
        ),
        Visibility(
          visible: showErr,
          child: Container(
            margin: EdgeInsets.only(left: 10, top: 5),
            child: Text(
              errText,
              style: TextStyle(color: Color(0xFFE02020)),
            ),
          ),
        ),
      ],
    );
  }
}
