import 'package:account_center/account_center.dart';
import 'package:account_center/common/utils/image_load.dart';
import 'package:account_center/common/utils/map_extension.dart';
import 'package:account_center/page/account_company/company_auth/widget/common/gesture_tap.dart';
import 'package:account_center/style/style_params.dart';
import 'package:account_center/widget/flow_position_tag.dart';
import 'package:account_center/widget/no_app_bar_scaffold.dart';
import 'package:flutter/material.dart';
import 'package:flutter_clx_base/widget/my_refresh_list_public.dart';

import 'account_center_logic.dart';

class AccountCenterPage extends StatelessWidget {
  final logic = Get.find<AccountCenterLogic>();
  final state = Get.find<AccountCenterLogic>().state;

  //颜色主
  final Color _color = const Color(0xFF171A1D);

  //字体颜色
  final Color _textColor = const Color(0xFF68717C);

  //字体样式
  final TextStyle textStyle = const TextStyle(
    color: Color(0xFF171A1D),
    fontWeight: FontWeight.w500,
    fontSize: 20,
  );

  AccountCenterPage({super.key});

  @override
  Widget build(BuildContext context) {
    return NoAppBarScaffold(
      imageUrl: StyleParams.userHomeBgUrl,
      child: GetBuilder<AccountCenterLogic>(builder: (logic) {
        return Column(
          children: [
            AppBar(
              centerTitle: true,
              elevation: 0,
              backgroundColor: Colors.transparent,
              foregroundColor: StyleParams.appBarTextColor,
              title: Text(
                state.defaultCompany,
                style: TextStyle(
                  color: StyleParams.appBarTextColor,
                  fontWeight: FontWeight.w500,
                  fontSize: 20,
                ),
              ),
            ),
            vGap30,
            Row(
              children: [
                hGap15,
                SizedBox(
                  width: 70,
                  height: 70,
                  child: ImageLoad.user(state.headImg,
                      fit: BoxFit.cover, type: ImageTransformerType.circle),
                ),
                hGap10,
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        children: [
                          Flexible(
                            child: Text(
                              state.userName,
                              maxLines: 1,
                              overflow: TextOverflow.ellipsis,
                              style: TextStyle(
                                  fontSize: 18.0,
                                  color: _color,
                                  fontWeight: FontWeight.w500),
                            ),
                          ),
                          hGap10,
                        ],
                      ),
                      vGap8,
                      Text(
                        state.userMobile,
                        style: TextStyle(color: _textColor, fontSize: 14.0),
                      ),
                    ],
                  ),
                ),
                Container(
                  padding: const EdgeInsets.only(
                    left: 10,
                    right: 10,
                    top: 5,
                    bottom: 5,
                  ),
                  decoration: BoxDecoration(
                      color: Colors.white,
                      gradient: LinearGradient(
                        begin: Alignment.centerLeft,
                        end: Alignment.centerRight,
                        colors: [
                          Color(0x00FFFFFF),
                          Color(0x33979797),
                        ],
                      )),
                  child: GestureTapWidget(
                    onTap: () {
                      Get.toNamed(RouteConfig.accountInfoPage);
                    },
                    child: Row(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        Text(
                          "账号信息",
                          style: TextStyle(fontSize: 14.0, color: _color),
                        ),
                        Icon(
                          Icons.arrow_forward_ios,
                          color: _color,
                          size: 13,
                        )
                      ],
                    ),
                  ),
                )
              ],
            ),
            vGap16,
            Expanded(
              child: MyListViewPublic(
                  controller: logic.listController,
                  firstRefresh: false,
                  canLoadMore: false,
                  itemBuilder: (BuildContext context, int index, itemData) {
                    if (index == 0) {
                      return Column(
                        children: [
                          Container(
                            margin: const EdgeInsets.only(
                              left: 10,
                              right: 10,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius:
                                  BorderRadius.all(Radius.circular(8)),
                            ),
                            child: Row(
                              children: [
                                _buildItem("加入/创建企业",
                                    "/icon/dev/png/20221102/8CFJC2Zttgba0Ii8.png",
                                    () {
                                  //加入/创建企业
                                  Get.toNamed(
                                      RouteConfig.joinOrNewEnterprisePage);
                                }),
                                _buildItem("企业管理",
                                    "/icon/dev/png/20221102/qXEZmtc98pXO6xTi.png",
                                    () {
                                  //企业管理
                                  Get.toNamed(RouteConfig.companyManager);
                                })
                              ],
                            ),
                          ),
                          Visibility(
                            visible: itemData['noData'] != true,
                            child: Container(
                              padding: const EdgeInsets.only(left: 22, top: 12),
                              child: Row(
                                children: [Text("产品相关公司")],
                              ),
                            ),
                          ),
                        ]..addIf(itemData['noData'] != true,
                            _buildCompanyInfoItem(itemData, index)),
                      );
                    }
                    return _buildCompanyInfoItem(itemData, index);
                  },
                  requestData:
                      (int page, int pageSize, SuccessCallback success, error) {
                    logic.listLoginUserProductCompany(
                        page, pageSize, success, error);
                  }),
            ),
          ],
        );
      }),
    );
  }

  // 企业信息item
  Widget _buildCompanyInfoItem(dynamic itemData, int index) {
    return InkWell(
      onTap: () {
        Get.toNamed(RouteConfig.companyHome,
            arguments: {"companyNo": itemData['companyNo']});
      },
      child: Container(
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(8),
        ),
        margin: const EdgeInsets.only(
          left: 10,
          right: 10,
          top: 10,
        ),
        padding: const EdgeInsets.only(
          left: 15,
          right: 15,
        ),
        height: 88,
        child: Row(
          children: [
            ImageLoad.companyLogo(itemData['companyLogo']),
            hGap10,
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Text(
                    (itemData as Map).getCompanyName(),
                    style: TextStyle(
                      color: _color,
                      fontSize: 16,
                    ),
                  ),
                  SizedBox(
                    height: 4,
                  ),
                  FlowPositionTag(tags: _positionTags(itemData)),
                ],
              ),
            ),
            Icon(
              Icons.arrow_forward_ios,
              color: _textColor,
              size: 15,
            )
          ],
        ),
      ),
    );
  }

  List<String> _positionTags(itemData) {
    List<String> positions = [];
    var departments = itemData['departmentAndPositionVos'];
    if (departments is List) {
      for (var element in departments) {
        var departmentName = element['department'] ?? itemData['companyName'];
        if (departmentName == null) {
          break;
        }
        if (element['position'] == null) {
          break;
        }
        positions.add(departmentName + '-' + element['position']);
      }
    }
    return positions;
  }

  Widget _buildItem(
    String name,
    String logo,
    onPress,
  ) {
    return Container(
      padding: const EdgeInsets.only(
        left: 23,
        right: 23,
        top: 16,
        bottom: 16,
      ),
      child: Column(
        children: [
          InkWell(
            onTap: onPress,
            child: SizedBox(
              height: 42,
              width: 42,
              child: ImageWidget.loadNetImage(ossDomain + logo,
                  fit: BoxFit.fill, type: ImageTransformerType.rect),
            ),
          ),
          vGap5,
          Text(
            name,
            style: TextStyle(fontSize: 12.0),
          ),
        ],
      ),
    );
  }

  Widget _chooseItem(String name, String logo, String no,
      {bool isPersonal = false}) {
    return GestureTapWidget(
      onTap: () {
        if (isPersonal) {
          logic.changeCompany(no, identityType: "personal");
        } else {
          logic.changeCompany(no, identityType: "company");
        }
        Get.back();
      },
      child: Column(
        children: [
          Container(
            padding: EdgeInsets.only(top: 10, bottom: 10, left: 15, right: 15),
            child: Row(
              children: [
                SizedBox(
                  width: 33,
                  height: 33,
                  child: ImageWidget.loadNetImage(logo,
                      fit: BoxFit.fill, type: ImageTransformerType.rect),
                ),
                hGap10,
                Expanded(
                    child: Text(
                  name,
                  style: TextStyle(color: _color, fontSize: 16),
                )),
                state.defaultCompanyNo == no
                    ? Icon(
                        Icons.check,
                        size: 20,
                      )
                    : Icon(null)
              ],
            ),
          ),
          Padding(
            padding: const EdgeInsets.only(left: 15, right: 15),
            child: line(),
          ),
        ],
      ),
    );
  }
}
