import 'package:flutter_clx_base/utils/toast_util.dart';
import 'package:open_filex/open_filex.dart';

abstract class FileUtil {
  static openFile(String path) async {
    OpenResult openResult = await OpenFilex.open(path);
    // final openResult = await OpenFile.open(path);
    if (openResult.type == ResultType.error) {
      ToastUtil.showToast(openResult.message);
    } else if (openResult.type == ResultType.permissionDenied) {
      ToastUtil.showToast("无权限");
    } else if (openResult.type == ResultType.fileNotFound) {
      ToastUtil.showToast("未发现文件");
    } else if (openResult.type == ResultType.noAppToOpen) {
      ToastUtil.showToast("无打开方式");
    } else {
      // ToastUtil.showToast(openResult.message);
    }
  }
}
