import 'package:flutter/material.dart';
import 'package:flutter_clx_base/flutter_clx_base.dart';
import 'package:fluttertoast/fluttertoast.dart';

class AlertUtil {
  /// 隐藏加载框
  static void dismissLoading() {
    LoadingUtils.dismiss();
  }

  /// 显示加载框
  static void showLoading({String text = ''}) {
    LoadingUtils.showLoading();
  }

  static void showCenterToast(String? txt,
      {ToastDuration toastDuration = ToastDuration.short}) {
    if (txt.isNullOrEmpty()) {
      txt = "信息异常";
    }
    Fluttertoast.showToast(
        msg: txt ?? "",
        toastLength: toastDuration == ToastDuration.long
            ? Toast.LENGTH_LONG
            : Toast.LENGTH_SHORT,
        gravity: ToastGravity.CENTER,
        // timeInSecForIos: 1,
        backgroundColor: const Color(0xB3000000),
        textColor: Colors.white,
        fontSize: 17.0);
  }
}
