//
//  UrlEncodeHelper.swift
//  account_center
//
//  Created by MrQi on 2025/3/12.
//

import Foundation


public class UrlEncodeHelper: NSObject {
    public class func encoded(string: String) -> String {
        do {
            let encoder = JSONEncoder()
            let jsonData = try encoder.encode(string)
            if let jsonString = String(data: jsonData, encoding: .utf8) {
                return jsonString
            }
        } catch {
            return ""
        }
        return ""
    }
    
    public class func decoded(string: String) -> String {
        let jsonData = string.data(using: .utf8)!
        let decoder = JSONDecoder()
        do {
            let decodedString = try decoder.decode(String.self, from: jsonData)
            return decodedString
        } catch {
            return ""
        }
    }
    
    public class func isUrlAddress(string: String) -> Bool {
        let reg = "((http[s]{0,1}|ftp)://[a-zA-Z0-9\\.\\-]+\\.([a-zA-Z]{2,4})(:\\d+)?(/[a-zA-Z0-9\\.\\-~!@#$%^&*+?:_/=<>]*)?)|(www.[a-zA-Z0-9\\.\\-]+\\.([a-zA-Z]{2,4})(:\\d+)?(/[a-zA-Z0-9\\.\\-~!@#$%^&*+?:_/=<>]*)?)"
        let urlPredicate: NSPredicate = NSPredicate(format: "SELF MATCHES %@", reg)
        return urlPredicate.evaluate(with: string)
    }
}
