import Flutter
import UIKit

public class SwiftAccountCenterPlugin: NSObject, FlutterPlugin {
  public static func register(with registrar: FlutterPluginRegistrar) {
    let channel = FlutterMethodChannel(name: "account_center", binaryMessenger: registrar.messenger())
    let instance = SwiftAccountCenterPlugin()
    registrar.addMethodCallDelegate(instance, channel: channel)
  }

  public func handle(_ call: FlutterMethodCall, result: @escaping FlutterResult) {
      if call.method == "startWebView" {
          guard let arguments = call.arguments as? [String: Any] else { return }
          guard let url = arguments["url"] as? String else { return }
          let vc = CLXWebViewController(url: url) { sign in
              result(["type": "sign", "result": sign])
          } realNameComplent: { realName in
              result(["type": "realName", "result": realName])
          } completion: {
              result(["type": "cancel", "result": -1])
          }

          vc.modalPresentationStyle = .fullScreen
          UIApplication.shared.keyWindow?.rootViewController?.present(vc, animated: true)
      } else {
          result("iOS " + UIDevice.current.systemVersion)
      }
  }
}
