//
//  RealnameConfig.swift
//  account_center
//
//  Created by MrQi on 2025/3/12.
//

import Foundation
import WebKit

typealias SignComplent = (_ result: Int) -> Void
typealias RealnameComplent = (_ result: Int) -> Void

public class RealnameConfig {
    
    var webView: WKWebView
    var navigationAction: WKNavigationAction
    var target: UIViewController?
    var url: URL? {
        return navigationAction.request.url
    }
    var decisionHandler: (WKNavigationActionPolicy) -> Void
    var signComplent: SignComplent?
    var realNameComplent: RealnameComplent?
    
    init(
        webView: WKWebView,
        navigationAction: WKNavigationAction,
        target: UIViewController?,
        decisionHandler: @escaping (WKNavigationActionPolicy) -> Void,
        signComplent: SignComplent?,
        realNameComplent: RealnameComplent?
    ) {
        self.webView = webView
        self.navigationAction = navigationAction
        self.target = target
        self.decisionHandler = decisionHandler
        self.signComplent = signComplent
        self.realNameComplent = realNameComplent
    }
}
