import UIKit
import account_center
import Flutter

@UIApplicationMain
@objc class AppDelegate: FlutterAppDelegate {
  override func application(
    _ application: UIApplication,
    didFinishLaunchingWithOptions launchOptions: [UIApplication.LaunchOptionsKey: Any]?
  ) -> Bool {
    GeneratedPluginRegistrant.register(with: self)
    return super.application(application, didFinishLaunchingWithOptions: launchOptions)
  }
    
    override func application(_ app: UIApplication, open url: URL, options: [UIApplication.OpenURLOptionsKey : Any] = [:]) -> Bool {
        if url.absoluteString.hasPrefix("clx://") {
            if url.absoluteString.query["realnameUrl"] != nil {
                let requestUrl = URL.init(string: url.absoluteString.query["realnameUrl"] as! String)
                if UIApplication.shared.windows.first?.rootViewController is CLXWebViewController {
                    let ctrl = UIApplication.shared.windows.first?.rootViewController as! CLXWebViewController as CLXWebViewController
                    ctrl.webView?.load(URLRequest(url: requestUrl!))
                } else if  UIApplication.shared.windows.first?.rootViewController?.presentedViewController is CLXWebViewController {
                    let ctrl = UIApplication.shared.windows.first?.rootViewController?.presentedViewController as! CLXWebViewController as CLXWebViewController
                    ctrl.webView?.load(URLRequest(url: requestUrl!))
                }
            }
        }
        return true
    }
}
