'''
@-*- coding: utf-8 -*-
@ python：python 3.9
@ 创建人员：libaofeng
@ 创建时间：2023/11/24
'''

import base64
import hashlib

from base.box_requests import BoxRequest


def md5(data):
    """
    使用md5进行加密
    :param data:
    :return:
    """
    if not isinstance(data, str):
        password = str(data)
    m = hashlib.new('md5')
    m.update(b'%s' % data.encode())
    return m.hexdigest()


def dispatch_center_load_images(headers, file_path):
    """
    上传图片通用接口
    :param headers: 请求头
    :param file_path: 文件路径
    :return: 完整的图片地址
    """
    with open(file_path, 'rb') as fin:
        image_data = fin.read()
        base64_data = base64.b64encode(image_data).decode()  # 图片编码为base64
    url = r'msl-message/file/uploadForm'
    method = 'post'
    data = {
        'file': base64_data
    }
    resp = BoxRequest(url, method, headers, data, content_type='form').resp_info
    return resp.get('data')



def update_images(headers, file_path, role):
    """
    接口上传的图片需要经过这个接口处理，返回存储到服务器图片的路径
    :param headers: 请求头
    :param file_path: 文件路径
    :param role: 角色
    :return: 完整的图片地址
    """
    with open(file_path, 'rb') as fin:
        image_data = fin.read()
        base64_data = base64.b64encode(image_data).decode()  # 图片编码为base64

    url = r'message-service/file/base64ImageList'
    method = 'post'
    base64_image = 'data:image/jpeg;base64,' + base64_data
    if role == 'owner':
        role = 'user'
    elif role == 'driver':
        role = 'truck'
    elif role == 'weight':  # 云磅房
        role = 'order'
    elif role == 'vip':  # VIP
        role = 'order'
    data = {'base64FileList': [base64_image], 'type': role}
    resp = BoxRequest(url, method, headers, data).resp_info
    return resp.get('data').get('pathList')[0]
