"""
@-*- coding: utf-8 -*-
@ python：python 3.9
@ 创建人员：libaofeng
@ 创建时间：2025/09/16
煤价分析工具上报端app用户数据上报流程
flask_receive_parameters/routes.py
API路由定义 - 使用类封装
"""
from data_center.coal_price_analysis_app import Coal_price_reporting_app
from flask import Blueprint, request, jsonify
import sys
import os


class APIHandler:
    """API请求处理器类"""
    def __init__(self):
        """初始化API处理器"""
        # 添加项目根目录到Python路径
        project_root = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))
        sys.path.append(project_root)
        self.Coal_reporting_user = Coal_price_reporting_app()     # 煤价分析上报端用户user
        self.Coal_price_reporting_app = Coal_price_reporting_app  # 导入业务模块

    def handle_test(self):
        """处理测试接口请求"""
        return jsonify({
            "message": "后端服务连接成功！",
            "status": "success"
        })

    def handle_run(self):
        """
        处理运行接口请求
        接收前端参数，调用execute_method_repeatedly方法
        """
        print("=" * 50)
        print("🚀 /api/run 接口被调用")
        print("=" * 50)

        try:
            # 1. 接收前端JSON数据
            data = request.get_json()
            if not data:
                return jsonify({"status": "error", "message": "未接收到有效数据"}), 400

            # 2. 提取参数
            param1 = data.get('param1')
            param2 = data.get('param2')

            print(f"📥 接收到的参数: param1={param1}, param2={param2}")
            print(f"📥 参数类型: param1={type(param1)}, param2={type(param2)}")

            # 3. 验证参数
            if param1 is None or param2 is None:
                return jsonify({
                    "status": "error",
                    "message": "缺少必要参数: param1 和 param2 是必填的"
                }), 400

            # 4. 检查模块导入是否成功
            if self.Coal_price_reporting_app is None:
                return jsonify({
                    "status": "error",
                    "message": "业务模块导入失败，请检查 data_center.coal_price_analysis_app 模块"
                }), 500

            # 5. 创建实例并调用方法
            coal_app = self.Coal_price_reporting_app()
            result = coal_app.execute_method_repeatedly(self.Coal_reporting_user.reporting_end_user, param1, param2)

            print(f"✅ 方法执行结果: {result}")
            print("=" * 50)

            # 6. 返回结果
            return jsonify({
                "status": "success",
                "received_params": {
                    "param1": param1,  # 前端传的第一个参数
                    "param2": param2,  # 前端传的第二个参数
                },
                "method_result": result if result is not None else "方法已执行（无返回值）",
                "message": f"执行成功"
            })

        except TypeError as error:
            # 专门处理参数错误
            if "missing 1 required positional argument" in str(error):
                return jsonify({
                    "status": "error",
                    "message": f"参数错误: 您的方法需要2个参数(param1, param2)，但只收到了{data.keys()}。"
                }), 400
            raise error

        except Exception as error:
            print(f"❌ 执行过程中发生错误: {str(error)}")
            import traceback
            traceback.print_exc()

            return jsonify({
                "status": "error",
                "message": f"执行错误: {str(error)}"
            }), 500


# 创建API处理器实例
api_handler = APIHandler()

# 创建蓝图
bp = Blueprint('receive_params', __name__)


# 注册路由
@bp.route('/api/test', methods=['GET'])
def test():
    """测试接口"""
    return api_handler.handle_test()


@bp.route('/api/run', methods=['POST'])
def run_code():
    """运行接口"""
    return api_handler.handle_run()


# 测试代码
if __name__ == '__main__':
    # 测试API处理器
    handler = APIHandler()
    print("🚨 这是路由文件，请通过 run.py 启动应用")