"""
@-*- coding: utf-8 -*-
@ python：python 3.9
@ 创建人员：libaofeng
@ 创建时间：2025/09/16
煤价分析工具上报端app用户数据上报流程
flask_receive_parameters/__init__.py
Flask应用工厂
"""
from flask import Flask
from .routes import bp  # 导入路由蓝图
from flask_cors import CORS


def create_app():
    """
    创建Flask应用实例
    """
    app = Flask(__name__)
    CORS(app)

    # 注册蓝图
    app.register_blueprint(bp)

    print("✅ Flask应用创建成功")
    print(f"✅ 注册蓝图: {bp.name}")

    return app


# 测试代码
if __name__ == '__main__':
    app = create_app()
    app.run(debug=True, host='0.0.0.0', port=5000)