'''
@-*- coding: utf-8 -*-
@ python：python 3.9
@ 创建人员：libaofeng
@ 创建时间：2023/11/24
'''
# -*- coding: utf-8 -*-
import json
import re

from requests import request
from config import ENV_PATH, DATA_UPLOADER


class BoxRequest():
    def __init__(self, url, method, headers, data=None, content_type='json'):
        self.url = self.url_path(url)
        self.method = self.check_method(method)
        self.data = data
        self.content_type = content_type
        self.headers = self.check_headers(headers)
        self._resp_msg = self._send_request()  # 把发送请求提成属性，目的是保证只会调用一次

    def url_path(self, url):
        # 给接口拼接ip+端口
        if url.find('http') >= 0:  # 判断请求url是否携带了ip和端口
            raise Exception('url{}不需要携带ip和端口'.format(url))
        try:
            service = re.search(r'(.*?)/', url).group(1)

            if service in DATA_UPLOADER:  # 如果是数据中心的服务
                url = ENV_PATH.get('data_uploader')+url
            return url
        except Exception as f:
            raise Exception('未解析到接口所对应的服务端口号')

    def check_method(self, method):
        # 校验请求方法是否符合要求
        standard_method = ('get', 'post', 'put', 'delete')
        if method not in standard_method:
            raise Exception('请求方法错误')
        return method

    def check_headers(self, headers):
        """
        校验请求头，
        content_type为form，将content-type改为form-data格式，params接参数
        content_type为form_url，将content-type改为form-url格式，data接参数，需将参数拼接为str
        :param headers:
        :return:
        """
        if self.content_type == 'form':
            headers['content-type'] = 'multipart/form-data; boundary=----WebKitFormBoundary22qc0YeSzHAJnSOL'
        elif self.content_type == 'form_url':
            headers['content-type'] = 'application/x-www-form-urlencoded;charset=UTF-8'
        else:
            headers['content-type'] = 'application/json'
        return headers

    def check_data(self, data):
        """
        校验参数
        :param data:
        :return:
        """
        # 判断请求类型是json，非get请求 并且是列表或字典类型，转换为json数据
        if self.headers.get('content-type') == 'application/json' and self.method != 'get' and (isinstance(data, list) or isinstance(data, dict)):
            return json.dumps(data)
        elif self.headers.get('content-type').find('form-url') >= 0 and (isinstance(data, list) or isinstance(data, dict)):
            # form-url类型，将参数转成字符串，汉字转换成latin1格式
            new_data = ''
            for k, v in data.items():
                new_data += '{}={}&'.format(k, v)
            return new_data.encode('utf-8').decode('latin1')
        else:
            return data

    def _send_request(self):
        # 如果是get请求 或者 表单传参数，用params接
        if self.method == 'get' or self.method == 'delete' or self.headers['content-type'].find('multipart/form-data') >= 0:
            resp = request(self.method, self.url, headers=self.headers, params=self.data)
        # 其他情况都将参数转换为json类型
        else:
            data = self.check_data(self.data)
            resp = request(self.method, self.url, headers=self.headers, data=data)
        return resp

    @property
    def resp_result(self):
        # 返回bool值，适用于新增或修改接口，校验是否请求成功

        # 如果返回值是一张图片，防止报错
        try:
            resp_content = self._resp_msg.json().get('msg')
            if self._resp_msg.status_code == 200 and resp_content == 'success':
                result = True
            else:
                result = False
            return result
        except Exception as f:
            pass

    @property
    def resp_info(self):
        # 返回所有响应结果，适用于查询接口

        resp = self._resp_msg.json()
        if self._resp_msg.status_code == 200 and resp.get('msg') == 'success':
            return resp
        else:
            raise Exception('接口返回错误，url：{}，状态码：{}，错误信息：{}，详细参数：{}'.format(self.url, self._resp_msg.status_code, resp.get('msg'), self.data))

    @property
    def resp_con(self):
        # 不做任何处理
        return self._resp_msg