'''
@-*- coding: utf-8 -*-
@ python：python 3.9
@ 创建人员：libaofeng
@ 创建时间：2023/11/24
'''
import queue
import time

import redis
from config import *
from pymysql import *


# 装饰redis类的方法， 作用是返回redis连接对象
def redis_obj(func):
    def func_in(*args, **kwargs):
        args_copy = args  # 将参数拷贝一份，原因：下面有删除操作，如果取数据报异常，重新从队列进行连接时，将参数复原
        redis_nodes = REDIS_CON
        redis_queue = queue.Queue()  # 创建队列对象
        for i in redis_nodes:
            redis_queue.put(i)  # 将redis连接集群添加到队列里
        while redis_queue.empty() is not True:  # 队列不为空，轮询
            self = args[0]  # 取出来，再放进去，为了不影响redis的连接对象r
            r = args[1]  # 解包 取出r，后面进行赋值使用, 类方法第一个参数为self，所以取的是索引1
            args = list(args)  # 转换为list，删除元素r，目的是后面将r进行单独传参，否则会报参数错误
            args.pop(0)
            args.pop(0)  # 删除前两个元素
            args = tuple(args)

            redis_con = redis_queue.get()  # 取出一个值进行连接
            r = redis.Redis(host=redis_con.get('host'), password=redis_con.get('password'), port=redis_con.get('port'))
            try:
                return func(self, r, *args, **kwargs)  # 调用被装饰的函数，
            except Exception as f:
                args = args_copy

    return func_in


class ConnectRedis(object):
    """
    创建redis连接对象，定义所有方法参数除了第一个self是默认的，还需传一个“r”，并且使用“redis_obj（）”进行装饰
    使用的时候，参数“r”随便传一个什么值都可以，在装饰器里面会处理成为redis连接对象返回
    """""

    def __init__(self):
        pass

    @redis_obj
    def write_hash_headers(self, r, role, mobile, data={}):
        # 在redis中求存储各端请头， 时间为7天
        r.hmset('test:headers:{}:{}'.format(role, mobile), data)
        r.expire('test:headers:{}:{}'.format(role, mobile), REDIS_SAVE_TIME)

    @redis_obj
    def read_headers(self, r, role, mobile):
        # 将读取出来的请求头（byte类型）转换成为字典
        byte_dict = r.hgetall('test:headers:{}:{}'.format(role, mobile))

        headers = {}
        for i in byte_dict:
            headers[i.decode()] = byte_dict[i].decode()
        return headers

    @redis_obj
    def del_headers(self, r, role, mobile):
        # 删除请求头
        r.delete('test:headers:{}:{}'.format(role, mobile))
        return

    @redis_obj
    def set_wallet(self, r, user_id, wallet):
        # 将用户钱包账号写入redis
        r.set('test:user_wallet:{}'.format(user_id), str(wallet), ex=REDIS_SAVE_TIME)

    @redis_obj
    def get_wallet(self, r, user_id):
        # 取出钱包账号
        return r.get('test:user_wallet:{}'.format(user_id))

    @redis_obj
    def get_test_mobile(self, r):
        # 获取一个测试用的手机号，然后重新设置
        mobile = r.get('test:mobile')
        if not mobile:
            r.set('test:mobile', 16100000100)
        new_mobile = int(mobile) + 1
        r.set('test:mobile', new_mobile)
        return mobile.decode()

    @redis_obj
    def search_captcha(self, r, mobile):
        # 查询图片验证码
        # try:
        name = 'login:owner:captcha:{}'.format(mobile)
        captcha = r.get(name)
        if captcha is None:
            # name = 'login:{}:captcha:null'.format(role)  # 特殊原因，验证码无法携带手机号
            name = 'login:owner:captcha:null'
            captcha = r.get(name)
        return captcha.decode()
        # except Exception as f:
        #     logger.info('查询验证码失败，手机号：{}，返回1234'.format(mobile))
        #     # return 1234

    @redis_obj
    def verify_mobile(self, r, mobile):
        # 查询短信验证码
        name = 'verify:mobile:{}:1'.format(mobile)
        mobile_code = r.get(name)
        if mobile_code is not None:
            return mobile_code.decode()

    @redis_obj
    def get_user_name(self, r):
        # 用于用户注册，取出一个名字
        return r.blpop('test:reg_name')[1].decode()

    @redis_obj
    def write_auto_test_child(self, r, child_no):
        # 自动化测试跑的运单写入redis
        r.lpush('test:auto_test:child_msg', child_no)

    @redis_obj
    def read_auto_test_child(self, r):
        # 读取自动化测试跑的运单
        child_list = r.lrange('test:auto_test:child_msg', 0, -1)
        for i in range(len(child_list)):
            child_list[i] = child_list[i].decode()
        return child_list

    @redis_obj
    def del_auto_test_child(self, r):
        # 删除自动化测试跑的运单
        while r.llen('test:auto_test:child_msg') > 0:
            r.lpop('test:auto_test:child_msg')

    @redis_obj
    def auto_test_child_time(self, r, type, time):
        # 保存自动化测试运单执行的开始和结束时间，作为统计筛选的时间范围,type:start_time or end_time
        r.set('test:auto_test:{}'.format(type), time)

    @redis_obj
    def read_auto_test_child_time(self, r, type):
        # 读取自动化测试运单执行的开始和结束时间，作为统计筛选的时间范围,type:start_time or end_time
        name = 'test:auto_test:{}'.format(type)
        date = r.get(name)
        return date.decode()


class ConnectMysql(object):
    def __init__(self, SQL_HOST, SQL_PORT, SQL_USERNAME, SQL_PASSWORD, database):
        # 留一点数据库更新的时间
        time.sleep(0.5)
        # 创建连接对象
        self.conn = connect(host=SQL_HOST, port=int(SQL_PORT), user=SQL_USERNAME, password=SQL_PASSWORD,
                            database=database, charset='gb2312')
        # 创建游标对象
        self.cs = self.conn.cursor()

    def __del__(self):
        # 关闭连接
        self.cs.close()
        self.conn.close()

    def delete(self, sql):
        self.cs.execute(sql)
        self.conn.commit()

    def update(self, sql):
        self.cs.execute(sql)
        self.conn.commit()

    def search(self, sql):
        # 执行sql
        self.cs.execute(sql)
        return self.see_list
        # for i in  self.cs.fetchall():
        #     print(i)

    @property
    def see_list(self):
        # 返回列表数据
        result = []
        data = self.cs.fetchall()

        for tuple_data in data:  # 查询出一个元组
            if len(tuple_data) == 1:
                for content in tuple_data:
                    result.append(content)
            else:
                result.append(tuple_data)

        return result
