"""
@-*- coding: utf-8 -*-
@ python：python 3.9
@ 创建人员：libaofeng
@ 创建时间：2023/11/24
"""

"""
用户体系通用登录方法
"""
from base.box_database import ConnectRedis
from base.box_requests import BoxRequest
from config import REPORT_APP_Content_Type, REPORT_APP_client_type, REPORT_APP_device_id, REPORT_APP_versionCode, REPORT_APP_versionName, REPORT_APP_model, REPORT_APP_imei, REPORT_APP_product_code, REPORT_APP_productType, REPORT_APP_productChannel, REPORT_APP_contentType


class AccountLogin(object):
    def __init__(self, **kwargs):
        """
        为方便各个地方调用，采用可变参数作为形参
        使用时，入参格式为 字典 类型，参数必须包括：product_code、mobile、password三个key
        且参数前必须加 **，用来解包
        """
        self.r = ConnectRedis()
        self.product_code = kwargs.get('product_code')
        self.mobile = kwargs.get('mobile')
        self.password = kwargs.get('password')
        self.headers = self._headers()
        # self._check_company()

    def _headers(self):
        # 直接查询redis，有值，return,无值，赋值
        headers_items = self.r.read_headers('r', self.product_code, self.mobile)
        if headers_items is None or len(headers_items) == 0:
            user_token = self._login(self.mobile, self.password, self.product_code)
            headers_items = {
                'token': user_token,
                'product-code': self.product_code,
                'content-type': 'application/json; charset=utf-8'
            }
            # app需要携带版本号和版本名称
            if self.product_code == 'trade-client-app':
                headers_items['Content-Type'] = REPORT_APP_Content_Type
                headers_items['client-type'] = REPORT_APP_client_type
                headers_items['device-id'] = REPORT_APP_device_id
                headers_items['versionCode'] = REPORT_APP_versionCode
                headers_items['versionName'] = REPORT_APP_versionName
                headers_items['model'] = REPORT_APP_model
                headers_items['imei'] = REPORT_APP_imei
                headers_items['product-code'] = REPORT_APP_product_code
                headers_items['productType'] = REPORT_APP_productType
                headers_items['productChannel'] = REPORT_APP_productChannel
                headers_items['contentType'] = REPORT_APP_contentType

            self.r.write_hash_headers('r', self.product_code, self.mobile, headers_items)

        # 如果redis里有值，需要校验准确性
        else:
            resp = self.is_login(headers_items.get('token'))
            if resp.get('data') is False:
                self.r.del_headers('r', self.product_code, self.mobile)
                return self._headers()
        return headers_items

    def _login(self, mobile, password, product_code):
        """
        所有用户登录都走这个验证码
        """
        url = f'coal-price-analysis/external/reportClient/login/login?code={password}&mobile={mobile}'
        method = 'get'
        headers = {
            'content-type': 'application/json; charset=utf-8',
            'product-code': product_code,
        }
        if product_code == 'msl-detection-app':
            url = r'msl-user/login/loginCaptcha'
            method = 'post'
            headers = {'Content-Type': 'application/json; charset=utf-8', 'product-code': product_code,
                       'client-type': REPORT_APP_client_type, 'device-id': REPORT_APP_device_id,
                       'versionCode': REPORT_APP_versionCode, 'versionName': REPORT_APP_versionName,
                       'model': REPORT_APP_model, 'imei': REPORT_APP_imei,
                       'productType': REPORT_APP_productType, 'productChannel': REPORT_APP_productChannel,
                       'contentType': REPORT_APP_contentType
                       }
        data = {
            'userMobile': mobile,
            'captcha': password
        }
        resp = BoxRequest(url, method, headers, data).resp_info
        if isinstance(resp['data'], dict):
            token = resp['data'].get('token')
        else:
            token = resp['data']
        return token

    # def is_login(self, token):
    #     """
    #     校验用户是否登录状态
    #     """
    #     url = r'sso/isLogin'
    #     method = 'get'
    #     headers = {
    #         'product-code': self.product_code,
    #         'token': token
    #     }
    #     resp = BoxRequest(url, method, headers).resp_info
    #     return resp



if __name__ == '__main__':
    user = AccountLogin(
        **{'mobile': '16600000000', 'password': '000000', 'product_code': 'coal-analysis-report-app'})
    print(user.headers)
