"""
@-*- coding: utf-8 -*-
@ python：python 3.9
@ 创建人员：libaofeng
@ 创建时间：2023/11/24
"""
import chardet
import random
import time
import string

import pymysql
import yaml
from urllib.parse import quote
from numpy.core.tests.test_simd import cls
from datetime import datetime, timedelta


class MethodTool:


    @staticmethod
    def get_current_time():
        """
        生成当前时间精确到秒
        :return:
        """
        # 获取当前时间精确到秒
        current_time = datetime.now()
        # 格式化时间字符串，精确到秒
        formatted_time = current_time.strftime("%Y-%m-%d %H:%M:%S")
        return formatted_time

    @staticmethod
    def current_time():
        """
        生成当前时间 精确到分
        :return:
        """
        current_time = datetime.now()
        formatted_time = current_time.strftime("%Y-%m-%d %H:%M")  # 格式化日期时间字符串
        return formatted_time

    @staticmethod
    def current_time_tow():
        """
        生成当前时间 精确到日
        :return:
        """
        current_time = datetime.now()
        formatted_time = current_time.strftime("%Y-%m-%d")  # 格式化日期时间字符串
        return formatted_time

    @staticmethod
    def get_start_of_day(hour, point, second):
        """
        生成当前日期及自定义时分秒
        :param hour:     时
        :param point:    分
        :param second:   秒
        :return:
        """
        now = datetime.now()
        start_of_day = datetime(now.year, now.month, now.day, hour, point, second)
        return start_of_day

    @staticmethod
    def process_number_advanced(value, reduction_factor=10, adjustment_range=10):
        """
        传入一个数值，对这个数值缩小十倍后再对这个数据加减10以内的数，保留两位小数
        用于产地信息上报的价格
        参数:
            value: 输入的数值
            reduction_factor: 缩小倍数 (默认10)
            adjustment_range: 随机调整范围 (默认10)

        返回:
            处理后的结果
        """
        try:
            num = float(value)
            reduced = num / reduction_factor
            adjustment = random.uniform(-adjustment_range, adjustment_range)
            return round(reduced + adjustment, 2)
        except (TypeError, ValueError):
            raise ValueError("输入必须是可以转换为数字的值")


    @staticmethod
    def process_number_integer(value, reduction_factor=10, adjustment_range=10):
        """
        传入一个数值，对这个数值缩小十倍后再对这个数据加减10以内的整数
        用于产地信息上报的价格

        参数:
            value: 输入的数值
            reduction_factor: 缩小倍数 (默认10)
            adjustment_range: 随机调整范围 (默认10)

        返回:
            处理后的整数结果
        """
        try:
            num = float(value)
            reduced = num / reduction_factor
            adjustment = random.uniform(-adjustment_range, adjustment_range)
            result = reduced + adjustment
            return round(result, 2)  # 先四舍五入再转换为整数
        except (TypeError, ValueError):
            raise ValueError("输入必须是可以转换为数字的值")

    @staticmethod
    def generate_random_number_custom(min_val=30, max_val=85, multiplier=100):
        """
        生成指定范围内的随机整数，然后乘以指定倍数返回

        参数:
            min_val: 最小值（默认30）
            max_val: 最大值（默认85）
            multiplier: 倍数（默认100）

        返回:
            float: 处理后的随机数
        """
        # 生成指定范围内的随机数
        random_num = int(random.uniform(min_val, max_val))

        # 乘以指定倍数
        result = random_num * multiplier

        return result

    @staticmethod
    def generate_random_range(min_val=10, max_val=22, decimal_places=2):
        """
        生成指定范围内的随机数
        参数:
            min_val: 最小值（默认10）
            max_val: 最大值（默认22）
            decimal_places: 小数位数（默认2）

        返回:
            float: 指定范围内的随机数
        """
        random_num = random.uniform(min_val, max_val)
        return round(random_num, decimal_places)

    @classmethod
    def reads_yaml(self, yaml_file_path):
        """
        读取yaml文件并将值组成列表
        :param yaml_file_path:  文件路径
        :return:
        """
        # 尝试多种编码
        try_encodings = ['utf-8', 'gbk', 'iso-8859-1']

        # 读取YAML文件
        for encoding in try_encodings:
            try:
                with open(yaml_file_path, 'r', encoding=encoding) as file:
                    yaml_content = yaml.safe_load(file)
                break
            except UnicodeDecodeError:
                continue

        # 如果尝试了所有编码仍然无法解码，使用 chardet 进行检测
        else:
            detected_encoding = cls.detect_encoding(yaml_file_path)
            with open(yaml_file_path, 'r', encoding=detected_encoding) as file:
                yaml_content = yaml.safe_load(file)

        return yaml_content
    @staticmethod
    def read_yaml(file_path):
        """
        读取yaml文件
        :param file_path: 文件路径
        :return: yaml文件内容
        """
        with open(file_path, 'r', encoding='utf-8') as file:
            values_data = yaml.safe_load(file)
            return values_data

    @staticmethod
    def write_yaml(file_path, values_data):
        """
        将数据写入yaml文件
        :param self:
        :param yaml_file_path:
        :return:
        """
        with open(file_path, 'w', encoding='utf-8') as file:
            yaml.dump(values_data, file, allow_unicode=True, default_flow_style=False)

    @staticmethod
    def detect_encoding(file_path):
        """
        使用 chardet 检测文件编码
        :param file_path: 文件路径
        :return: 检测到的编码
        """
        with open(file_path, 'rb') as file:
            result = chardet.detect(file.read())
        return result['encoding']

if __name__ == '__main__':
    tool = MethodTool()
    random_number = tool.process_number_integer(4700, 10, 10)
    print(random_number)

