"""
@-*- coding: utf-8 -*-
@ python：python 3.9
@ 创建人员：libaofeng
@ 创建时间：2025/09/16
煤价分析工具上报端app用户数据上报流程
"""

import threading
import random
from ensurepip import version

from lib.log import logger
from lib.random_tool import MethodTool
from base.box_requests import BoxRequest
from support.account_login import AccountLogin
from config import DISPATCH_CENTER_USER_MESSAGE


class Coal_price_reporting_app(object):
    """
    煤价分析工具上报端app操作类，初始化init方法将左右的角色都登录
    每个方法都需传一个user，直接从属性里拿即可
    """
    # 测试git
    _instance_lock = threading.Lock()
    _init_flag = False  # 此变量判断是否需要初始化__init__

    def __new__(cls, *args, **kwargs):
        if not hasattr(Coal_price_reporting_app, "_instance"):
            with Coal_price_reporting_app._instance_lock:
                if not hasattr(Coal_price_reporting_app, "_instance"):
                    Coal_price_reporting_app._instance = object.__new__(cls)
                    Coal_price_reporting_app._init_flag = True
        return Coal_price_reporting_app._instance

    def __init__(self):
        if Coal_price_reporting_app._init_flag is True:
            self.reporting_end_user = AccountLogin(
                **DISPATCH_CENTER_USER_MESSAGE.get('data_uploader_app'))  # 煤价分析上报端用户
            Coal_price_reporting_app._init_flag = False

# """---------------------------------------------------产地信息上报---------------------------------------------------"""
    def list_place_of_origin(self, user):
        """
        产地上报—获取可选产地列表
        :param user:
        :return:  可选产地数据列表
        """
        url = r'coal-price-analysis/reportClient/address/pageAddressByBusinessType'
        method = 'post'
        data = {
            'businessType': 1,
            'name': None,
            'page': 1,
            'pageSize': 100
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data').get('records')
        return resp

    def list_coal_type(self, user):
        """
        产地上报—可选煤种列表
        :param user:
        :return:
        """
        url = r'coal-price-analysis/reportClient/coalType/listCoalTpe'
        method = 'get'
        resp = BoxRequest(url, method, user.headers).resp_info.get('data')
        return resp

    def list_destination(self, user):
        """
        目的地列表
        :param user:
        :return:
        """
        url = r'coal-price-analysis/reportClient/freightAddrConfig/listEnableFreightAddressConfig'
        method = 'get'
        resp = BoxRequest(url, method, user.headers).resp_info.get('data')
        return resp

    def save_origin_reporting(self, user, task_id=None, address_id=None, address_name=None, price_information_list=None, destination_id=None):
        """
        产地上报
        :param user:
        :param task_id:                 任务ID——主动上报没有任务ID，通过今日任务上报有任务ID
        :param address_id:              产地ID——主动上报自主选择产地，通过今日任务上报固定产地
        :param address_name:            产地名称
        :param price_information_list:  销售价格信息——如果是任务接口会返需要上报的销售价格信息
        :param destination_id:          目的地ID
        :return:
        """
        list_place_of_origin = self.list_place_of_origin(user)           # 获取可选产地列表
        if address_id is None:                                           # 如果产地address_id为空时，说明是自主上报，可以自行随机选择产地进行上报
            get_place_of_origin = random.choice(list_place_of_origin)    # 随机获取产地列表的一个产地信息
            address_id = get_place_of_origin.get('id')                   # 获取产地id值 对该产地进行上报
            address_name = get_place_of_origin.get('name')               # 获取产地名称信息 用于日志输出
        # else：如果产地address_id不空时，说明是通过任务上报，不可以自行随机选择产地进行上报，需要根据任务信息进行对应的产地上报
        if task_id is None:                                              # 如果任务task_id为空时，说明是自主上报，任务ID可以传None，
            task_id = None
        # else:如果任务task_id不为空时，说明是任务上报，传任务ID
        if price_information_list is None:
            report_count = random.randint(5, 15)                        # 随机生产一个本次上报价格信息数量
            seen_combinations = set()                                        # 创建一个空集合，用于记录已经出现过的组合
            price_information_list = []                                      # 创建一个空列表，用于存放销售价格信息
            list_coal_type = self.list_coal_type(user)                       # 提前获取煤种列表，避免重复调用
            for i in range(report_count):
                # 尝试生成唯一组合，避免过多重复尝试，因为产品上报时，多个销售价格信息中不允许出现煤种和热值相同的数据
                for attempt in range(10):                                    # 最多尝试10次
                    get_coal_type = random.choice(list_coal_type)            # 随机获取一个煤种
                    coal_type_id = get_coal_type.get('code')                 # 获取煤种ID
                    coal_type_name = get_coal_type.get('mark')               # 获取煤种名称
                    coal_type_calorific = MethodTool.generate_random_number_custom(min_val=30, max_val=85, multiplier=100)  # 随机生成一个热值
                    combination = (coal_type_id, coal_type_calorific)        # 创建一个元组，包含两个值

                    if combination not in seen_combinations:                 # 判断当前元祖在seen_combinations集合里是否存在
                        seen_combinations.add(combination)                   # 不存在说明该煤种信息及热值可以添加，没有重复
                        price = MethodTool.process_number_integer(coal_type_calorific, 10, 10)  # 生成价格
                        price_information_list.append({                      # 生成销售价格信息
                            'calorific': coal_type_calorific,
                            'coalTypeId': coal_type_id,
                            'coalTypeName': coal_type_name,
                            'price': price,
                            'taskChildId': None
                        })
                        break
        # else:如果任务task_id不为空时，说明是任务上报，直接读销售价格信息列表
        if destination_id is None:
            list_destination = self.list_destination(user)                    # 代办任务上报——运费信息—目的地列表
            destination_id = list_destination[0].get('addressVo').get('id')   # 获取第一个目的地ID
        # else:如果任务task_id不为空时，说明是任务上报，直接取传来的目的地ID
        url = r'coal-price-analysis/reportClient/originPlaceReport/saveReportRecord'
        method = 'post'
        data = {
            'taskId': task_id,                                                 # 主任务ID
            'reportId': None,
            'addressType': None,                                               # 地址类型
            'addressId': address_id,                                           # 产地id
            'saleInfoParamList': price_information_list,                       # 销售价格信息
            'freightAddressReportParamList': [
                {
                    'addressId': destination_id,                               # 目的地ID
                    'price': MethodTool.generate_random_range(min_val=10, max_val=22, decimal_places=2),  # 运费价格
                    'type': 1                                                  # 目的地类型
                }
            ]
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data')
        if task_id is None:
            logger.info('产地信息主动上报成功：')
            logger.info(f'产地名称为：{address_name}')
            for item in price_information_list:
                logger.info(f"  煤种：{item['coalTypeName']}      热值: {item['calorific']} Kcal/kg       本期价格: {item['price']} 元/吨")
        else:
            logger.info('产地任务上报成功：')
            logger.info(f'产地名称为：{address_name}')
            for item in price_information_list:
                logger.info(f"  煤种：{item['coalTypeName']}      热值: {item['calorific']} Kcal/kg       本期价格: {item['price']} 元/吨")
        return resp

# """-------------------------------------------------下游消耗信息上报--------------------------------------------------"""
    def xiayou_optional_address_list(self, user):
        """
       下游消耗信息上报——可选地址列表
        :param user:
        :return:
        """
        url = r'coal-price-analysis/reportClient/address/pageAddressByBusinessType'
        method = 'post'
        data = {
            'businessType': 5,
            'name': None,
            'page': 1,
            'pageSize': 1000
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data').get('records')
        return resp

    def xiayou_information_reporting(self, user):
        """
        下游消耗信息上报
        :param user:
        :return:
        """
        xiayou_optional_address_list = self.xiayou_optional_address_list(user)      # 可选上报地址列表
        xiayou_optional_address_get = random.choice(xiayou_optional_address_list)   # 随机选区一个地址
        address_id = xiayou_optional_address_get.get('id')                          # 获取地址ID
        address_name = xiayou_optional_address_get.get('name')                      # 获取地址名称
        report_count = random.randint(5, 15)  # 随机生产一个本次上报价格信息数量
        seen_combinations = set()  # 创建一个空集合，用于记录已经出现过的组合
        price_information_list = []  # 创建一个空列表，用于存放销售价格信息
        list_coal_type = self.list_coal_type(user)  # 提前获取煤种列表，避免重复调用
        for i in range(report_count):
            # 尝试生成唯一组合，避免过多重复尝试，因为产品上报时，多个销售价格信息中不允许出现煤种和热值相同的数据
            for attempt in range(10):  # 最多尝试10次
                get_coal_type = random.choice(list_coal_type)  # 随机获取一个煤种
                coal_type_id = get_coal_type.get('code')  # 获取煤种ID
                coal_type_name = get_coal_type.get('mark')  # 获取煤种名称
                coal_type_calorific = MethodTool.generate_random_number_custom(min_val=30, max_val=85,
                                                                               multiplier=100)  # 随机生成一个热值
                combination = (coal_type_id, coal_type_calorific)  # 创建一个元组，包含两个值

                if combination not in seen_combinations:  # 判断当前元祖在seen_combinations集合里是否存在
                    seen_combinations.add(combination)  # 不存在说明该煤种信息及热值可以添加，没有重复
                    price = MethodTool.process_number_integer(coal_type_calorific, 10, 10)    # 生成价格
                    inventory = MethodTool.generate_random_number_custom(min_val=50, max_val=200, multiplier=100)          # 生成随机库存
                    daily_consumption = MethodTool.generate_random_number_custom(min_val=30, max_val=100, multiplier=100)  # 生成随机日销量
                    purchase_volume = MethodTool.generate_random_number_custom(min_val=30, max_val=100, multiplier=100)    # 生成随机采购量
                    price_information_list.append({              # 生成销售价格信息
                        'calorific': coal_type_calorific,        # 热值
                        'coalTypeId': coal_type_id,              # 煤种ID
                        'coalTypeName': coal_type_name,          # 煤种名称
                        'price': price,                          # 价格
                        'inventory': inventory,                  # 库存
                        'dailyConsumption': daily_consumption,   # 日销量
                        'purchaseChannel': '线上销售',            # 销售渠道
                        'purchaseVolume': purchase_volume        # 采购量
                    })
                    break

        queuing_trucks = MethodTool.generate_random_number_custom(min_val=1, max_val=10, multiplier=10)   # 生成随机排队车辆数
        unloaded_trucks = MethodTool.generate_random_number_custom(min_val=1, max_val=10, multiplier=10)  # 生成随机已卸车辆数
        price = MethodTool.generate_random_range(min_val=10, max_val=22, decimal_places=2)                # 生成随机运费
        list_destination = self.list_destination(user)  # 目的地列表
        destination_id = list_destination[0].get('addressVo').get('id')  # 获取第一个目的地ID
        url = r'coal-price-analysis/reportClient/downstreamReport/saveReportRecord'
        method = 'post'
        data = {
            'taskId': None,
            'reportId': None,
            'addressType': None,
            'addressId': address_id,             # 地址ID
            'queuingTrucks': queuing_trucks,     # 排队车辆数
            'unloadedTrucks': unloaded_trucks,   # 已卸车辆数
            'purchaseInfoParams': price_information_list,
            'freightAddressReportParamList':  [
                {
                    'addressId': destination_id,
                    'price': price,
                    'type': 1
                }
            ]
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data')
        logger.info('下游消耗信息主动上报成功：')
        logger.info(f'地址名称为：{address_name}')
        for item in price_information_list:
            logger.info(
                f"  煤种：{item['coalTypeName']}   热值: {item['calorific']} Kcal/kg    价格: {item['price']} 元/吨   库存：{item['inventory']}吨   日消耗量：{item['dailyConsumption']}吨   采购渠道：{item['purchaseChannel']}  采购量：{item['purchaseVolume']}吨")
        logger.info(f'排队车辆数:{queuing_trucks} 辆   已卸车车辆数：{unloaded_trucks} 辆    运费：{price} 元/吨')
        return resp

# """-------------------------------------------------港口生产信息上报--------------------------------------------------"""
    def gangkou_port_list(self, user):
        """
        港口生产信息上报——获取可选港口列表
        :param user:
        :return:
        """
        url = r'coal-price-analysis/reportClient/address/pageAddressByBusinessType'
        method = 'post'
        data = {
            'businessType': 3,
            'name': None,
            'page': 1,
            'pageSize': 10,
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data').get('records')
        return resp

    def gangkou_information_reporting(self, user, task_id=None, address_id=None, address_name=None, task_child_id=None):
        """
        港口生产信息上报
        :param user:
        :param task_id: 任务ID——主动上报没有任务ID，通过今日任务上报有任务ID
        :param address_id:港口ID——主动上报自主选择产地，通过今日任务上报固定港口
        :param address_name: 港口名称
        :param task_child_id: 子任务ID
        :return:
        """
        transfer_volume = MethodTool.generate_random_number_custom(min_val=10, max_val=100, multiplier=100)  # 生成随机调入量
        export_volume = MethodTool.generate_random_number_custom(min_val=10, max_val=100, multiplier=100)    # 生成随机调出量
        on_job_ship = MethodTool.generate_random_number_custom(min_val=10, max_val=70, multiplier=1)          # 生成随机在港作业船舶
        anchor_ships = MethodTool.generate_random_number_custom(min_val=10, max_val=70, multiplier=1)         # 生成随机锚地船舶
        prearrival_ship = MethodTool.generate_random_number_custom(min_val=70, max_val=150, multiplier=1)      # 生成随机预到船舶
        inventory = MethodTool.generate_random_number_custom(min_val=50, max_val=100, multiplier=100)        # 生成随机当日库存
        if address_id is None:
            gangkou_port_list = self.gangkou_port_list(user)                                                       # 获取可选港口列表
            gangkou_port_get = random.choice(gangkou_port_list)
            address_id = gangkou_port_get.get('id')
            address_name = gangkou_port_get.get('name')
        # else：如果产地address_id不空时，说明是通过任务上报，不可以自行随机选择港口进行上报，需要根据任务信息进行对应的港口上报
        if task_id is None:
            task_id = None

        url = r'coal-price-analysis/reportClient/harborReport/saveReportRecord'
        method = 'post'
        data = {
            'taskId': task_id,
            'reportId': None,
            'addressType': None,
            'addressId': address_id,                # 港口id
            'transferVolume': transfer_volume,      # 调入量
            'exportVolume': export_volume,          # 调出量
            'onJobShip': on_job_ship,               # 在港作业船舶
            'anchorShips': anchor_ships,            # 锚地船舶
            'prearrivalShip': prearrival_ship,      # 预到船舶
            'inventory': inventory,                 # 当日库存
        }
        if task_child_id is not None:
            data['taskChildId'] = task_child_id
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data')
        logger.info('港口生产信息主动上报成功：')
        logger.info(f'港口名称为：{address_name}')
        logger.info(f"  调入量：{data['transferVolume']} 万吨   调出量: {data['exportVolume']} 万吨    当日库存: {data['inventory']} 万吨 ")
        logger.info(f"  在港作业船舶:{data['onJobShip']} 艘   锚地船舶：{data['anchorShips']} 艘    预到船舶：{data['prearrivalShip']} 艘")
        return resp

# """-------------------------------------------------神华采购信息上报--------------------------------------------------"""
    def shenhua_purchase_default_address(self, user):
        """
        神华采购价格信息上报——默认地址信息——巴图塔
        :param user:
        :return:
        """
        url = r'coal-price-analysis/reportClient/address/shenhuaPurchaseDefaultAddress'
        method = 'get'
        resp = BoxRequest(url, method, user.headers).resp_info.get('data')
        return resp

    def shenhua_optional_address_list(self, user):
        """
        神华销售/采购价格信息上报———可选地址列表
        :param user:
        :return:
        """
        url = r'coal-price-analysis/reportClient/address/pageAddressByBusinessType'
        method = 'post'
        data = {
            'businessType': 5,
            'name': None,
            'page': 1,
            'pageSize': 1000
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data').get('records')
        return resp

    def shenhua_address_information(self, user, site_id):
        """
        神华采购价格信息上报——获取地址上报信息
        :param user:
        :param site_id:
        :return:
        """
        current_time_tow = MethodTool.current_time_tow()  # 获取当前时间，精确到日
        url = f'coal-price-analysis/reportClient/shenhuaPurchaseReport/getLastPurchaseReportByDate?effectiveTime={current_time_tow}&siteId={site_id}'
        method = 'get'
        resp = BoxRequest(url, method, user.headers).resp_info.get('data')
        return resp

    def shenhua_coal_types_list(self, user):
        """
        神华采购/销售价格信息上报——获取可选煤种列表
        :param user:
        :return:
        """
        url = r'coal-price-analysis/reportClient/shenhuaCoalType/listEnableCoalType'
        method = 'get'
        resp = BoxRequest(url, method, user.headers).resp_info.get('data')
        return resp

    def shenhua_purchase_report(self, user):
        """
        神华采购价格信息上报
        :param user:
        :return:
        """
        optional_address_list = self.shenhua_optional_address_list(user)                 # 可选地址列表
        site_id = random.choice(optional_address_list)['id']                             # 随机获取一个地址ID上报
        site_name = random.choice(optional_address_list)['name']                         # 随机获取一个地址名称上报
        address_reporting_information = self.shenhua_address_information(user, site_id)  # 获取地址上报信息
        shenhua_coal_types_list = self.shenhua_coal_types_list(user)                     # 获取可选煤种列表
        coal_type_list = []
        for coal_type_get in shenhua_coal_types_list:
            if coal_type_get.get('name') == '外购5000':
                coal_type_list.append(
                    {
                        'coalTypeId': coal_type_get.get('id'),
                        'price': MethodTool.process_number_integer(4900, 10, 20)
                    }
                )
            elif coal_type_get.get('name') == '外购5800':
                coal_type_list.append(
                    {
                        'coalTypeId': coal_type_get.get('id'),
                        'price': MethodTool.process_number_integer(5700, 10, 20)
                    }
                )
            elif coal_type_get.get('name') == '外购4500':
                coal_type_list.append(
                    {
                        'coalTypeId': coal_type_get.get('id'),
                        'price': MethodTool.process_number_integer(4400, 10, 20)
                    }
                )
            elif coal_type_get.get('name') == '外购5500':
                coal_type_list.append(
                    {
                        'coalTypeId': coal_type_get.get('id'),
                        'price': MethodTool.process_number_integer(5400, 10, 20)
                    }
                )
            elif coal_type_get.get('name') == '中长协5000':
                coal_type_list.append(
                    {
                        'coalTypeId': coal_type_get.get('id'),
                        'price': MethodTool.process_number_integer(4900, 10, 20)
                    }
                )
            elif coal_type_get.get('name') == '中长协4500':
                coal_type_list.append(
                    {
                        'coalTypeId': coal_type_get.get('id'),
                        'price': MethodTool.process_number_integer(4400, 10, 20)
                    }
                )
            elif coal_type_get.get('name') == '中长协5500':
                coal_type_list.append(
                    {
                        'coalTypeId': coal_type_get.get('id'),
                        'price': MethodTool.process_number_integer(5400, 10, 20)
                    }
                )
            else:
                coal_type_list.append(
                    {
                        'coalTypeId': coal_type_get.get('id'),
                        'price': MethodTool.process_number_integer(3900, 10, 20)
                    }
                )
        if address_reporting_information.get('version') is not None:                     # 查询版本号信息
            version = address_reporting_information.get('version')
        else:
            version = None
        current_time_tow = str(MethodTool.get_start_of_day(18, 00, 00))  # 获取当前时间，精确到秒
        url = r'coal-price-analysis/reportClient/shenhuaPurchaseReport/saveReportRecord'
        method = 'post'
        data = {
            'taskId': None,
            'siteId': site_id,
            'effectiveTime': current_time_tow,
            'coalTypeList': coal_type_list,
            'forceSaveFlag': 0,
            'version': version
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data')
        logger.info(f'神华采购价格信息上报成功，上报站点信息为：{site_name}')
        for item in coal_type_list:
            for shenhua_coal_types_get in shenhua_coal_types_list:
                if shenhua_coal_types_get.get('id') == item.get('coalTypeId'):
                    coal_type_name = shenhua_coal_types_get.get('name')
            logger.info(
                f"  煤种：{coal_type_name}      本期价格: {item['price']} 元/吨")
        return resp

# """-----------------------------------------------神华销售价格信息上报------------------------------------------------"""
    def last_time_shenhua_address_information(self, user):
        """
        神华销售价格信息上报——默认的地址信息——巴图塔
        :param user:
        :return:
        """
        url = r'coal-price-analysis/reportClient/address/shenhuaPriceDefaultAddress'
        method = 'get'
        resp = BoxRequest(url, method, user.headers).resp_info.get('data')
        return resp

    def shenhua_address_reporting_information(self, user, site_id):
        """
        神华销售价格信息上报——获取地址上报信息
        :param user:
        :param site_id: 地址ID
        :return:
        """
        current_time_tow = MethodTool.current_time_tow()  # 获取当前时间，精确到日
        url = f'coal-price-analysis/reportClient/shenhuaPriceReport/getLastPriceReportByDate?effectiveDate={current_time_tow}&siteId={site_id}'
        method = 'get'
        resp = BoxRequest(url, method, user.headers).resp_info.get('data')
        return resp

    def shenhua_sales_report(self, user, task_id=None, site_id=None, site_name=None, new_price_site_info_list=None):
        """
        神华销售价格信息上报
        :param user:
        :param task_id:
        :param site_id:
        :param site_name:
        :param new_price_site_info_list:
        :return:
        """
        shenhua_coal_types_list = self.shenhua_coal_types_list(user)
        price_site_info_list = []
        version = None
        if task_id is None:
            optional_address_list = self.shenhua_optional_address_list(user)                           # 可选地址列表
            site_id = random.choice(optional_address_list)['id']                                       # 随机获取一个地址ID上报
            site_name = random.choice(optional_address_list)['name']
            for coal_type_get in shenhua_coal_types_list:
                if coal_type_get.get('name') == '外购5000':
                    price_site_info_list.append(
                        {
                            'coalTypeId': coal_type_get.get('id'),
                            'currentPrice': MethodTool.process_number_integer(5000, 10, 20)
                        }
                    )
                elif coal_type_get.get('name') == '外购5800':
                    price_site_info_list.append(
                        {
                            'coalTypeId': coal_type_get.get('id'),
                            'currentPrice': MethodTool.process_number_integer(5800, 10, 20)
                        }
                    )
                elif coal_type_get.get('name') == '外购4500':
                    price_site_info_list.append(
                        {
                            'coalTypeId': coal_type_get.get('id'),
                            'currentPrice': MethodTool.process_number_integer(4500, 10, 20)
                        }
                    )
                elif coal_type_get.get('name') == '外购5500':
                    price_site_info_list.append(
                        {
                            'coalTypeId': coal_type_get.get('id'),
                            'currentPrice': MethodTool.process_number_integer(5500, 10, 20)
                        }
                    )
                elif coal_type_get.get('name') == '中长协5000':
                    price_site_info_list.append(
                        {
                            'coalTypeId': coal_type_get.get('id'),
                            'currentPrice': MethodTool.process_number_integer(4900, 10, 20)
                        }
                    )
                elif coal_type_get.get('name') == '中长协4500':
                    price_site_info_list.append(
                        {
                            'coalTypeId': coal_type_get.get('id'),
                            'currentPrice': MethodTool.process_number_integer(4500, 10, 20)
                        }
                    )
                elif coal_type_get.get('name') == '中长协5500':
                    price_site_info_list.append(
                        {
                            'coalTypeId': coal_type_get.get('id'),
                            'currentPrice': MethodTool.process_number_integer(5500, 10, 20)
                        }
                    )
                else:
                    price_site_info_list.append(
                        {
                            'coalTypeId': coal_type_get.get('id'),
                            'currentPrice': MethodTool.process_number_integer(4000, 10, 20)
                        }
                    )
            address_reporting_information = self.shenhua_address_reporting_information(user, site_id)  # 获取地址上报信息
            if address_reporting_information.get('version') is not None:                               # 查询版本号信息
                version = address_reporting_information.get('version')
        for price_site_info_get in new_price_site_info_list:
            coal_type_id = price_site_info_get['coalTypeId']
            task_child_id = price_site_info_get['taskChildId']
            for coal_type_get in shenhua_coal_types_list:
                if coal_type_get.get('id') == coal_type_id:
                    if coal_type_get.get('name') == '外购5000':
                        price_site_info_list.append(
                            {
                                'coalTypeId': coal_type_get.get('id'),
                                'currentPrice': MethodTool.process_number_integer(5000, 10, 20),
                                'taskChildId': task_child_id
                            }
                        )
                    elif coal_type_get.get('name') == '外购5800':
                        price_site_info_list.append(
                            {
                                'coalTypeId': coal_type_get.get('id'),
                                'currentPrice': MethodTool.process_number_integer(5800, 10, 20),
                                'taskChildId': task_child_id
                            }
                        )
                    elif coal_type_get.get('name') == '外购4500':
                        price_site_info_list.append(
                            {
                                'coalTypeId': coal_type_get.get('id'),
                                'currentPrice': MethodTool.process_number_integer(4500, 10, 20),
                                'taskChildId': task_child_id
                            }
                        )
                    elif coal_type_get.get('name') == '外购5500':
                        price_site_info_list.append(
                            {
                                'coalTypeId': coal_type_get.get('id'),
                                'currentPrice': MethodTool.process_number_integer(5500, 10, 20),
                                'taskChildId': task_child_id
                            }
                        )
                    elif coal_type_get.get('name') == '中长协5000':
                        price_site_info_list.append(
                            {
                                'coalTypeId': coal_type_get.get('id'),
                                'currentPrice': MethodTool.process_number_integer(4900, 10, 20),
                                'taskChildId': task_child_id
                            }
                        )
                    elif coal_type_get.get('name') == '中长协4500':
                        price_site_info_list.append(
                            {
                                'coalTypeId': coal_type_get.get('id'),
                                'currentPrice': MethodTool.process_number_integer(4500, 10, 20),
                                'taskChildId': task_child_id
                            }
                        )
                    elif coal_type_get.get('name') == '中长协5500':
                        price_site_info_list.append(
                            {
                                'coalTypeId': coal_type_get.get('id'),
                                'currentPrice': MethodTool.process_number_integer(5500, 10, 20),
                                'taskChildId': task_child_id
                            }
                        )
                    else:
                        price_site_info_list.append(
                            {
                                'coalTypeId': coal_type_get.get('id'),
                                'currentPrice': MethodTool.process_number_integer(4000, 10, 20),
                                'taskChildId': task_child_id
                            }
                        )
        current_time_tow = MethodTool.current_time_tow()                                           # 获取当前时间，精确到日
        url = r'coal-price-analysis/reportClient/shenhuaPriceReport/saveReportRecord'
        method = 'post'
        data = {
            'taskId': task_id,
            'siteId': site_id,
            'effectiveDate': current_time_tow,
            'priceSiteInfoList': price_site_info_list,
            'forceSaveFlag': 0,
            'version': version
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data')
        logger.info(f'神华销售价格信息上报成功,上报站点名称为：{site_name}')
        for item in price_site_info_list:
            for shenhua_coal_types_get in shenhua_coal_types_list:
                if shenhua_coal_types_get.get('id') == item.get('coalTypeId'):
                    coal_type_name = shenhua_coal_types_get.get('name')
            logger.info(
                f"  煤种：{coal_type_name}      本期价格: {item['currentPrice']} 元/吨")
        return resp

# """-------------------------------------------------CCI指数信息上报--------------------------------------------------"""
    def cci_return_index(self, user):
        """
        CCI指数信息上报——CCI指数信息上报数据反值——获取该接口返回的version值，在上报的时候传参用
        :param user:
        :return: version值
        """
        current_time_tow = MethodTool.current_time_tow()  # 获取当前时间，精确到日
        url = f'coal-price-analysis/reportClient/shenhuaCCIReport/getLastCCIReportByDate?date={current_time_tow}'
        method = 'get'
        resp = BoxRequest(url, method, user.headers).resp_info.get('data')
        return resp

    def cci_report_index(self, user):
        """
        CCI指数信息上报———CCI指数信息上报
        :param user:
        :return:
        """
        cci_index = self.cci_return_index(user)                                     # 获取CCI指数信息上报数据反值
        report_list = cci_index.get('reportList')                                   # 获取CCI指数信息上报数据反中的热值数据
        for item in report_list:
            if 'currentPrice' in item:
                adjustment = random.uniform(-15, 15)                             # 生成-15到15之间的随机价格值
                item['currentPrice'] = round(item['currentPrice'] + adjustment, 2)  # 更新价格值
        version = cci_index.get('version')                                          # 查询版本号信息

        url = 'coal-price-analysis/reportClient/shenhuaCCIReport/saveReportRecord'
        method = 'post'
        data = {
            'taskId': None,
            'effectiveDate': MethodTool.current_time_tow(),                         # 获取当前时间，精确到日
            'cciSiteInfoList': report_list,
            'forceSaveFlag': 0,
            'version': version
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data')
        logger.info('CCI指数信息上报成功：')
        for item in report_list:
            logger.info(f"  热值: {item['calorificValue']}, 本期价格: {item['currentPrice']}")
        return resp

# """---------------------------------------------------运费信息上报---------------------------------------------------"""
    def yunfei_address_list(self, user):
        """
        运费信息上报——发/收货地址列表
        :param user:
        :return:
        """
        url = 'coal-price-analysis/reportClient/address/pageAddressByBusinessType'
        method = 'post'
        data = {
            'businessType': None,
            'name': None,
            'page': 1,
            'pageSize': 100
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data').get('records')
        return resp

    def yunfei_information_reporting(self, user):
        """
        运费信息上报——
        :param user:
        :return:
        """
        yunfei_address_list = self.yunfei_address_list(user)
        yunfei_address_get = random.choice(yunfei_address_list)
        send_address_id = yunfei_address_get.get('id')
        send_address_name = yunfei_address_get.get('name')
        yunfei_address_get = random.choice(yunfei_address_list)
        receive_address_id = yunfei_address_get.get('id')
        receive_address_name = yunfei_address_get.get('name')
        transport_distance = MethodTool.generate_random_number_custom(min_val=200, max_val=10000, multiplier=1)  # 生成随机拉运车辆数
        truck_quantity = MethodTool.generate_random_number_custom(min_val=100, max_val=10000, multiplier=1)      # 生成随机拉运车辆数
        local_trucks_proportion = MethodTool.generate_random_number_custom(min_val=20, max_val=80,
                                                                           multiplier=1)  # 生成随机本地车占比
        effective_time = MethodTool.current_time()                                        # 生成当前时间，精确到分
        url = r'coal-price-analysis/reportClient/freightReport/saveReportRecord'
        method = 'post'
        data = {
            'taskId': None,
            'reportId': None,
            'sendAddressId': send_address_id,                  # 发货地址
            'receiveAddressId': receive_address_id,            # 收货地址
            'transportDistance': transport_distance,           # 运距
            'freight': MethodTool.generate_random_range(min_val=10, max_val=22, decimal_places=2),                                # 运费
            'truckQuantity': truck_quantity,                   # 拉运车辆
            'localTrucksProportion': local_trucks_proportion,  # 本地车辆占比
            'remark': ' 佛曰:  写字楼里写字间，写字间里程序员；程序人员写程序，又拿程序换酒钱。酒醒只在网上坐，酒醉还来网下眠；酒醉酒醒日复日，'
                      '网上网下年复年。 但愿老死电脑间，不愿鞠躬老板前；奔驰宝马贵者趣，公交自行程序员。别人笑我忒疯癫，我笑自己命太贱；不见满街漂亮妹，哪个归得程序员？',
            'effectiveTime': effective_time,                   # 运费生效时间
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data')
        logger.info('运费信息主动上报成功：')
        logger.info(f'上报发货地址为： {send_address_name}      上报收货地址为：{receive_address_name}')
        logger.info(
            f"  运距: {transport_distance} KM    运费: {data['freight']}元/吨   运费生效时间：{effective_time}   拉运车辆：{truck_quantity}    本地车辆占比：{local_trucks_proportion}   外地车辆占比{100-local_trucks_proportion}")
        logger.info(
            f"  备注：{data['remark']}")
        return resp

# """---------------------------------------------------重点区域上报---------------------------------------------------"""
    def zhongdian_address_list(self, user):
        """
        重点区域上报——可选地址列表
        :param user:
        :return:
        """
        url = r'coal-price-analysis/reportClient/address/pageAddressByBusinessType'
        method = 'post'
        data = {
            'businessType': None,
            'name': None,
            'page': 1,
            'pageSize': 100,
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data').get('records')
        return resp

    def zhongdian_regional_reporting(self, user):
        """
        重点区域上报
        :param user:
        :return:
        """
        zhongdian_address_list = self.zhongdian_address_list(user)
        zhongdian_address_get = random.choice(zhongdian_address_list)
        report_id = zhongdian_address_get.get('id')
        report_name = zhongdian_address_get.get('name')
        truck_situation = random.randint(1, 3)
        truck_quantity = MethodTool.generate_random_number_custom(min_val=100, max_val=1000, multiplier=1)  # 生成随机拉运车辆数
        local_trucks_proportion = MethodTool.generate_random_number_custom(min_val=20, max_val=80, multiplier=1)  # 生成随机本地车占比
        url = r'coal-price-analysis/reportClient/keyAreasReport/saveReportRecord'
        method = 'post'
        data = {
            'taskId': None,
            'reportId': None,
            'addressId': report_id,                            # 地址ID
            'truckSituation': truck_situation,                 # 车辆情况  1=畅通  2=一般   3=拥堵
            'truckQuantity': truck_quantity,                   # 拉运车辆数
            'localTrucksProportion': local_trucks_proportion,  # 本地车占比
            'remark': '佛曰:  写字楼里写字间，写字间里程序员；程序人员写程序，又拿程序换酒钱。酒醒只在网上坐，酒醉还来网下眠；酒醉酒醒日复日，'
                      '网上网下年复年。 但愿老死电脑间，不愿鞠躬老板前；奔驰宝马贵者趣，公交自行程序员。别人笑我忒疯癫，我笑自己命太贱；不见满街漂亮妹，哪个归得程序员？',                              # 备注
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data')
        logger.info('重点区域主动上报成功：')
        logger.info(f'上报地址为： {report_name}')
        logger.info(f"  拉运车数: {truck_quantity} 量    区域车辆情况: {truck_situation}   本地车辆占比：{local_trucks_proportion}   外地车辆占比：{100-local_trucks_proportion}")
        logger.info(
            f"  备注：{data['remark']}")
        return resp

# """-------------------------------------------------海运指数信息上报--------------------------------------------------"""
    def haiyun_last_reported_information(self, user):
        """
        海运指数信息上报——查询上次上报记录
        :param user:
        :return:
        """
        current_time_tow = MethodTool.current_time_tow()  # 获取当前时间，精确到日
        url = f'coal-price-analysis/reportClient/shippingIndex/report/getLastReportByDate?date={current_time_tow}'
        method = 'get'
        resp = BoxRequest(url, method, user.headers).resp_info.get('data')
        return resp

    def haiyun_route_list(self, user):
        """
        海运指数信息上报——航线列表
        :param user:
        :return:
        """
        url = r'coal-price-analysis/reportClient/shippingIndex/report/listShippingRoutes'
        method = 'get'
        resp = BoxRequest(url, method, user.headers).resp_info.get('data')
        return resp

    def haiyun_information_reporting(self, user):
        """
        海运指数信息上报
        :param user:
        :return:
        """
        current_time_tow = MethodTool.current_time_tow()        # 获取当前时间，精确到日
        haiyun_last_reported_information = self.haiyun_last_reported_information(user)  # 获取pc段配置的航线上报信息
        haiyun_report_information_list = haiyun_last_reported_information.get('reportList')
        shipping_index_report_info_params_lsit = []

        for item in haiyun_report_information_list:
            # 1. 读取shippingRoutesId和currentPrice字段
            shipping_routes_id = item.get('shippingRoutesId')
            current_price = item.get('currentPrice')
            # 2. 处理currentPrice字段
            if current_price is None or current_price == '':
                # 如果没有值，生成500-1000的随机数值，保留2位小数
                current_price = round(random.uniform(500, 1000), 2)
                print(f"ID {shipping_routes_id}: currentPrice为空，已设置为: {current_price}")
            # 3. 创建新的字典
            new_dict = {
                'shippingRoutesId': shipping_routes_id,
                'currentPrice': current_price
            }
            shipping_index_report_info_params_lsit.append(new_dict)
        if haiyun_last_reported_information.get('version') is not None:
            version = haiyun_last_reported_information.get('version')
        else:
            version = None
        url = r'coal-price-analysis/reportClient/shippingIndex/report/save'
        method = 'post'
        data = {
            'taskId': None,
            'effectiveTime': current_time_tow,
            'shippingIndexReportInfoParams': shipping_index_report_info_params_lsit,
            'forceSaveFlag': 0,
            'version': version
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data').get('records')
        logger.info('海运指数信息上报成功：')
        for item in shipping_index_report_info_params_lsit:
            for haiyun_last_reported in haiyun_report_information_list:
                if haiyun_last_reported.get('shippingRoutesId') == item.get('shippingRoutesId'):
                    route_name = haiyun_last_reported.get('routeName')
            logger.info(f"  航线: {route_name}, 本期点数/价格: {item['currentPrice']}")
        return resp

    # """-------------------------------------------------上报产地代办任务--------------------------------------------------"""
    def list_tasks_to_be_reported(self, user):
        """
        代办任务上报——进行中的任务列表
        :param user:
        :return:
        """
        url = r'coal-price-analysis/reportClient/task/all/report/page'
        method = 'post'
        data = {
            'page': 1,
            'pageSize': 10,
            'status': 10,
            'businessTypes': [1, 3, 9, 4, 5, 6],
            'addressName': '',
            'publishTimeStart': str(MethodTool.get_start_of_day(00, 00, 00)),
            'publishTimeEnd': str(MethodTool.get_start_of_day(23, 59, 59)),
        }
        resp = BoxRequest(url, method, user.headers, data).resp_info.get('data').get('records')
        return resp

    def report_task_to_do(self, user, task_id):
        """
        代办任务上报——查询产地任务上报信息
        :param task_id: 任务id
        :param user:
        :return:
        """
        url = f'coal-price-analysis/reportClient/task/originPlaceDetail?id={task_id}'
        method = 'get'
        resp = BoxRequest(url, method, user.headers).resp_info.get('data')
        return resp

    def query_gangkou_task_information(self, user, task_id):
        """
        代办任务上报——查询港口任务上报信息
        :param user:
        :param task_id:
        :return:
        """
        url = f'coal-price-analysis/reportClient/task/harborDetail?id={task_id}'
        method = 'get'
        resp = BoxRequest(url, method, user.headers).resp_info.get('data')
        return resp

    def query_shenhuasales_task_information(self, user, task_id):
        """
        代办任务上报——查询神华销售任务上报信息
        :param user:
        :param task_id:
        :return:
        """
        url = f'coal-price-analysis/reportClient/task/shenhuaSaleDetail?id={task_id}'
        method = 'get'
        resp = BoxRequest(url, method, user.headers).resp_info.get('data')
        return resp


    def destination_information_list(self, user):
        """
        代办任务上报——运费信息—目的地信息
        :param user:
        :return:
        """
        url = r'coal-price-analysis/reportClient/freightAddrConfig/listEnableFreightAddressConfig'
        method = 'get'
        resp = BoxRequest(url, method, user.headers).resp_info.get('data')
        return resp

    def chandi_task_reporting(self, user):
        """
        代办任务上报——
        :param user:
        :return:
        """
        list_tasks_to_be_reported = self.list_tasks_to_be_reported(user)       # 获取进行中的任务列表
        # get_tasks_to_be_reported = random.choice(list_tasks_to_be_reported)  # 随机获取任务
        get_tasks_to_be_reported = list_tasks_to_be_reported[0]                # 获取列表第一个任务
        task_id = get_tasks_to_be_reported.get('taskId')                       # 获取任务ID
        if get_tasks_to_be_reported.get('businessTypeName') == '产地':          # 如果是产地任务就执行产地任务上报
            task_information = self.report_task_to_do(user, task_id)           # 查询需上报任务信息
            address_id = task_information.get('address').get('id')             # 获取需上报的地址ID
            address_name = task_information.get('address').get('name')         # 获取需上报的地址名称
            sale_info_list = task_information.get('saleInfoList')              # 获取需上报的销售价格信息
            price_information_list = []
            for item in sale_info_list:
                # 提取需要的字段
                coal_type_calorific = item.get('coalTypeCalorific')
                coal_type_id = item.get('coalTypeId')
                coal_type_name = item.get('coalTypeName')
                task_child_id = item.get('taskChildId')
                price = MethodTool.process_number_integer(coal_type_calorific, 10, 10)  # 生成价格
                # 创建新的字典
                new_dict = {
                    'calorific': coal_type_calorific,  # 原coalTypeCalorific字段
                    'coalTypeId': coal_type_id,
                    'coalTypeName': coal_type_name,
                    'price': price,  # 根据规则计算的价格
                    'taskChildId': task_child_id
                }
                price_information_list.append(new_dict)
            destination_id = self.destination_information_list(user)[0].get('addressVo').get('id')  # 目的地ID
            chandi_task_reporting = self.save_origin_reporting(user, task_id, address_id, address_name, price_information_list, destination_id)  # 执行产地任务上报
            return chandi_task_reporting
        elif get_tasks_to_be_reported.get('businessTypeName') == '港口':                             # 如果是港口任务
            query_gangkou_task_information = self.query_gangkou_task_information(user, task_id)     # 获取任务详情
            address_id = query_gangkou_task_information.get('address').get('id')                    # 获取港口ID
            address_name = query_gangkou_task_information.get('address').get('name')                # 获取港口名称
            task_child_id = query_gangkou_task_information.get('taskChildId')                       # 获取子任务ID
            gangkou_information_reporting = self.gangkou_information_reporting(user, task_id, address_id, address_name, task_child_id)   # 执行港口任务上报
            return gangkou_information_reporting

        elif get_tasks_to_be_reported.get('businessTypeName') == '神华销售价格':                      # 如果是神华销售价格任务
            query_shenhuasales_task_information = self.query_shenhuasales_task_information(user, task_id)
            address_id = query_shenhuasales_task_information.get('addressId')
            address_name = query_shenhuasales_task_information.get('addressName')
            item_vos = query_shenhuasales_task_information.get('itemVos')
            shenhua_sales_report = self.shenhua_sales_report(user, task_id, address_id, address_name, item_vos)
            return shenhua_sales_report
        else:
            logger.info('没有该任务项')
            wu = None
            return wu

# """--------------------------------------------------循环执行上报----------------------------------------------------"""
    def execute_method_repeatedly(self, user, reporting_type, times):
        """
        循环执行指定方法多次
        上报类型：1=产地上报  2=下游上报  3=港口上报  4=神华采购价格上报  5=神华销售价格上报  6=CCI指数上报  7=运费上报  8=重点区域上报  9=海运指数上报
        参数:
            method: 要执行的方法
            reporting_type: 上报类型
            times: 执行次数
            *args: 方法的位置参数
            **kwargs: 方法的关键字参数
        返回:
            list: 每次执行的返回结果列表
        """
        results = []
        for i in range(1, times + 1):
            logger.info(f"正在执行第 {i}/{times} 次...")
            try:
                if reporting_type == 1:       # 产地信息上报
                    result = self.save_origin_reporting(user)
                elif reporting_type == 2:     # 下游消耗信息上报
                    result = self.xiayou_information_reporting(user)
                elif reporting_type == 3:     # 港口生成信息上报
                    result = self.gangkou_information_reporting(user)
                elif reporting_type == 4:     # 神华采购信息上报
                    result = self.shenhua_purchase_report(user)
                elif reporting_type == 5:     # 神华销售价格信息上报
                    result = self.shenhua_sales_report(user)
                elif reporting_type == 6:     # CCI指数信息上报
                    result = self.cci_report_index(user)
                elif reporting_type == 7:     # 运费上报
                    result = self.yunfei_information_reporting(user)
                elif reporting_type == 8:     # 重点区域上报
                    result = self.zhongdian_regional_reporting(user)
                elif reporting_type == 9:     # 海运指数信息上报
                    result = self.haiyun_information_reporting(user)
                else:
                    logger.info(f'提醒您：您输入的上报类型为{reporting_type} ，经过系统查询后暂无该上报类型，请检查后重试！')
                    break
                results.append(result)
            except Exception as e:
                error_msg = f"第 {i} 次执行出错: {str(e)}"
                results.append((False, None, error_msg))
                logger.info(error_msg)
        return results


if __name__ == '__main__':
    report_obj = Coal_price_reporting_app()

    # 循环执行上报
    # 上报类型：1=产地上报  2=下游上报  3=港口上报  4=神华采购价格上报  5=神华销售价格上报  6=CCI指数上报  7=运费上报  8=重点区域上报  9=海运指数上报
    execute_method_repeatedly = report_obj.execute_method_repeatedly(report_obj.reporting_end_user, 1, 100)  # 传上报类型、执行上报次数
    logger.info(execute_method_repeatedly)

    # report_cci_index = report_obj.chandi_task_reporting(report_obj.reporting_end_user)  # 代办任务上报
    # logger.info(report_cci_index)

    # shenhua_sales_report = report_obj.query_shenhuasales_task_information(report_obj.reporting_end_user, 104637)  # 神华销售价格上报
    # logger.info(shenhua_sales_report)

    # list_tasks_to_be_reported = report_obj.destination_information(report_obj.reporting_end_user)  # 执行代办任务
    # logger.info(list_tasks_to_be_reported)
