'''
@-*- coding: utf-8 -*-
@ python：python 3.9
@ 创建人员：libaofeng
@ 创建时间：2023/11/24
'''
from selenium import webdriver
from config.constant import CHROME_DRIVER


class WebDriver(object):
    def __init__(self):
        pass

    def open_browser(self, set_headless_browser=True):
        """
        创建chrome参数对象
        :param set_headless_browser: 是否设置无头浏览器
        :return: driver对象
        """
        opt = webdriver.ChromeOptions()
        if set_headless_browser is True:
            # 把chrome设置成无界面模式，不论windows还是linux都可以，自动适配对应参数
            opt.set_headless()
        # 设置窗口大小
        chrome_options = opt.add_argument("--window-size=1920,1080")
        driver = webdriver.Chrome(executable_path=CHROME_DRIVER, options=opt, chrome_options=chrome_options)

        driver.implicitly_wait(2)  # 隐式等待时间2秒
        return driver
