package com.clx.performance.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.ArtificialCancelOrderParam;
import com.clx.performance.param.pc.ArtificialCancelOrderQueryParam;
import com.clx.performance.param.pc.OrderCancelParam;
import com.clx.performance.param.pc.OrderChildCancelRecordParam;
import com.clx.performance.vo.app.OrderChildVO;
import com.clx.performance.vo.pc.OrderChildOperateRecordVO;

public interface OrderCancelService {

    /**
     * 承运端取消订单，货主同意调用此接口
     * @param orderNo
     */
    void ownerConfirmCancelOrderPre(String orderNo);

    void ownerConfirmCancelProcess(String orderNo);

    /**
     * 货主取消订单前置（只修改订单状态）
     * @param param
     */
    Integer ownerCancelOrderPre(OrderCancelParam param);

    /**
     * 平台取消订单前置(只修改订单状态)
     * @param param
     */
//    void platformCancelOrderPre(OrderCancelParam param);

    /**
     * 修改订单状态后执行归还吨数
     * @param param
     */
    void orderCancelProcess(OrderCancelParam param);

    /**
     * 客服取消
     * @param orderChildNo
     */
    void artificialCancelOrder(String orderChildNo, String remark);

    /**
     * 客服取消运单查询
     * @param orderChildNo
     * @return
     */
    OrderChildVO findArtificialCancelOrder(ArtificialCancelOrderQueryParam param);

    IPage<OrderChildVO> orderChildCancelRecord(OrderChildCancelRecordParam param);

    /**
     * 异常运单处理记录
     * @param param
     * @return
     */
    IPage<OrderChildOperateRecordVO> orderChildOperateRecord(OrderChildCancelRecordParam param);

    /**
     * 客服移除监装限制
     * @param param
     */
    void removeLoadLimit(ArtificialCancelOrderParam param);
}
