package com.clx.performance.mapper.settle;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.model.settle.NetworkDriverAccount;
import com.clx.performance.param.pc.PageNetworkAccountListParam;
import com.clx.performance.sqlProvider.settle.NetworkDriverAccountProvider;
import com.clx.performance.vo.pc.IntegralRecordVO;
import com.clx.performance.vo.pc.NetworkDriverAccountVO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;
import org.apache.ibatis.annotations.Update;

/**
 * @author kavin
 * Date 2023-12-19
 * Time 11:34
 */
public interface NetworkDriverAccountMapper extends BaseMapper<NetworkDriverAccount> {

    @SelectProvider(type = NetworkDriverAccountProvider.class, method = "networkAccountList")
    IPage<NetworkDriverAccountVO> networkAccountList(@Param("page")Page<NetworkDriverAccountVO> page, @Param("param")PageNetworkAccountListParam param);

    @Update("update network_driver_account set usable_balance = usable_balance + #{account.usableBalance}"
            + ",account_balance = account_balance + #{account.accountBalance}"
            + ",modified_time= #{now}"
            + "where id = #{account.id} and modified_time = #{account.modifiedTime}"
    )
    Integer addAccount(@Param("account") NetworkDriverAccount account, @Param("now") String now);

    @Update("update network_driver_account set usable_balance = usable_balance - #{account.usableBalance}," +
            "frozen_balance = frozen_balance + #{account.frozenBalance},account_balance = account_balance - #{account.accountBalance}," +
            "modified_time=#{now}"
            + "where id = #{account.id} and modified_time = #{account.modifiedTime}"
    )
    Integer subAccount(@Param("account") NetworkDriverAccount account, @Param("now") String now);

}
