package com.clx.performance.vo.pc.nbbank;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
* @Author: aiqinguo
* @Description: 订单状态
* @Date: 2024/01/17 13:42:57
* @Version: 1.0
*/

@Getter
@Setter
@ToString
@NoArgsConstructor
public class NbBankOrderResultVO {

    @Schema(description = "金额（分）", example = "")
    private Integer amount;
    @Schema(description = "实收金额（分）", example = "")
    private Integer realAmount;

    @Schema(description = "商户时间")
    private String merDtTm;
    @Schema(description = "商户流水号", example = "20231129145541")
    private String merSeqNo;
    @Schema(description = "第三方流水号", example = "20231129145541065503563czKTBzy")
    private String transSeqNo;
    @Schema(description = "转账编号（转账专用）", example = "1234567")
    private String signNo;

    @Schema(description = "交易状态：1交易成功 2交易失败 3交易已受理 4订单初始状态 5交易不存在 6交易超时", example = "1")
    private Integer status;

}