package com.clx.performance.vo.pc.carrier.settle;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

/**
 * @Description
 * @Author jiangwenye
 * @Date 2024/01/25 15:01
 * @Version 1.0
 */
@Getter
@Setter
public class CarrierPagePlatformAccountConfigVO {

    @Schema(description = "id")
    private Integer id;
    @Schema(description = "应用场景 1-结算单，2-违约结算单，3-充值，4-提现")
    private Integer businessType;
    @Schema(description = "应用场景")
    private String businessTypeMsg;
    @Schema(description = "货主类型 1-企业，2-个人")
    private Integer ownerType;
    @Schema(description = "货主类型")
    private String ownerTypeMsg;
    @Schema(description = "开票标识：1网运单 2普通单")
    private Integer invoiceType;
    @Schema(description = "开票标识")
    private String invoiceTypeMsg;
    @Schema(description = "开票公司id")
    private Integer invoiceCompanyId;
    @Schema(description = "开票公司名称")
    private String invoiceCompanyName;
    @Schema(description = "配置范围：1收款账户 2付款账户")
    private Integer configRange;
    @Schema(description = "配置范围")
    private String configRangeMsg;

    @Schema(description = "公司名称")
    private String companyName;
    @Schema(description = "银行名称")
    private String bankName;
    @Schema(description = "开户行")
    private String openBank;
    @Schema(description = "银行编码")
    private String bankCode;
    @Schema(description = "银行账号")
    private String bankCardNo;

    @Schema(description = "创建人编码")
    private Long createUserNo;
    @Schema(description = "创建人姓名")
    private String createUserName;
    @Schema(description = "修改人编码")
    private Long modifiedUserNo;
    @Schema(description = "修改人姓名")
    private String modifiedUserName;

    @Schema(description = "删除状态: 0-否;1-是")
    private Integer deleteStatus;
    @Schema(description = "创建时间")
    private String createTime;
    @Schema(description = "修改时间")
    private String modifiedTime;

}
