package com.clx.performance.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Optional;

public enum PerformanceProgressEnum {
    ;


    //1：进行中的线路（不分页）  2：已结束线路  3：全部线路
    @Getter
    @AllArgsConstructor
    public enum Tab {

        IN_PROCESS(1, "进行中的线路"),

        END(2, "已结束线路"),

        ALL(3, "全部线路"),

        ;

        private final Integer code;
        private final String name;

        public static Optional<Tab> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(Tab::getName).orElse(null);
        }
    }



    @Getter
    @AllArgsConstructor
    public enum LogType {

        TODAY_EXPECT_COMPLETE(1, "今日预计完成吨数"),
        TRADE_REQUIRE_ARRIVE_STATION_TIME(2, "交易要求到站时间"),
        TRANSPORT_EXPECT_ARRIVE_STATION_TIME(3, "物流预计到站时间"),
        ABNORMAL_REMARK(4, "异常备注"),
        PERFORMANCE_ABNORMAL_REASON(5, "履约异常原因"),
        DISPATCH_FOLLOW(6, "调度备注/跟进措施"),
        ;

        private final Integer code;
        private final String name;

        public static Optional<LogType> getByCode(Integer code) {
            return Arrays.stream(values()).filter(e -> e.code.equals(code)).findFirst();
        }

        public static String getMsgByCode(int code) {
            return getByCode(code).map(LogType::getName).orElse(null);
        }
    }


}
