package com.clx.performance.param.pc;

import com.msl.common.convertor.type.MoneyInConvert;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;


@Schema(description = "货主提现")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class OwnerCaseOutParam {

    @Schema(description = "货主用户编号", example = "123")
    private Long ownerUserNo;

    @Schema(description = "提现金额（元）", example = "1.23")
    @MoneyInConvert
    private BigDecimal caseOutBalance;

    @Schema(description = "账户类型： 1：保证金 2：预付运费", example = "1")
    private Integer accountType;

    @Schema(description = "提现银行开户行", example = "浙江银行开户行")
    private String ownerOpenBank;

    @Schema(description = "提现银行卡号", example = "62213545878787")
    private String ownerBankAccount;

    @Schema(description = "交易密码")
    private String accountPassword;

}