package com.clx.performance.param.pc;

import com.msl.common.convertor.field.Converted;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;

@Data
public class OrderGoodsParams {

    @Schema(description="订单编号")
    @NotBlank(message = "订单编号不能为空")
    private String orderNo;

    @Valid
    @Converted(isDynamic = true)
    private List<OrderGoodsChildParams> orderGoodsChildParams;
}
