package com.clx.performance.model.collect;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-10-17
 * Time 16:26
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("collect_driver_transport_intention")
public class CollectDriverTransportIntention implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("sort_no")
    @Schema(description="排序编号")
    private Long sortNo;

    @TableField("collect_name")
    @Schema(description="问题名称")
    private String collectName;

    @TableField("collect_describe")
    @Schema(description="问题描述")
    private String collectDescribe;

    @TableField("collect_check_type")
    @Schema(description="状态：1单选 2多选")
    private Integer collectCheckType;

    @TableField("collect_type")
    @Schema(description="状态：1拉运意向 2拒绝拉运")
    private Integer collectType;

    @TableField("create_user_no")
    @Schema(description="操作人编码")
    private Long createUserNo;

    @TableField("create_user_name")
    @Schema(description="操作人")
    private String createUserName;

    @TableField("delete_status")
    @Schema(description="删除状态: 0-否;1-是")
    private Integer deleteStatus;

    @TableField("status")
    @Schema(description="状态：1启用 2禁用")
    private Integer status;

    @TableField("create_time")
    @Schema(description="创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @Schema(description="修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
