package com.clx.performance.controller.pc.loan.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.OwnerLoanAccountApproveParam;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountApproveParam;
import com.clx.performance.service.loan.OwnerLoanAccountApproveService;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanAccountApproveVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @ClassName CarrierOwnerLoanAccountApproveController
 * @Description
 * @Author kavin
 * @Date 2024/1/20 17:52
 * @Version 1.0
 */
@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/ownerLoanAccountApprove")
@Validated
@Tag(name = "承运端-运营管理")
@AllArgsConstructor
public class CarrierOwnerLoanAccountApproveController {

    private final OwnerLoanAccountApproveService ownerLoanAccountApproveService;

    @Operation(summary = "货主借款账户审核列表",description = "<br>By:刘海泉")
    @PostMapping("/pageOwnerLoanAccountApprove")
    public Result<PageData<OwnerLoanAccountApproveVO>> pageOwnerLoanAccountApprove(@RequestBody @Validated PageOwnerLoanAccountApproveParam param) {
        IPage<OwnerLoanAccountApproveVO> page  = ownerLoanAccountApproveService.pageOwnerLoanAccountApprove(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }

    @Operation(summary = "货主借款账户审批",description = "<br>By:胡宇帆")
    @PostMapping("/ownerLoanAccountApprove")
    public Result<Object> ownerLoanAccountApprove(@RequestBody @Validated OwnerLoanAccountApproveParam param) {
        ownerLoanAccountApproveService.ownerLoanAccountApprove(param);
        return Result.ok();
    }
}
