package com.clx.performance.controller.pc;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.pc.DealExceptionReportParam;
import com.clx.performance.param.pc.PageExceptionReportParam;
import com.clx.performance.param.pc.TransferDriverBreakContractParam;
import com.clx.performance.service.OrderChildExceptionReportService;
import com.clx.performance.vo.pc.OrderChildExceptionReportVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/exceptionReport")
@Validated
@Tag(name = "承运端-异常上报")
@AllArgsConstructor
public class OrderChildExceptionReportController {

    private final OrderChildExceptionReportService orderChildExceptionReportService;

    @Operation(summary = "异常上报处理", description = "<br>By:刘海泉")
    @PostMapping(value = "updateDealExceptionReport")
    public Result<Object> updateDealExceptionReport(@RequestBody @Validated DealExceptionReportParam param) {
        orderChildExceptionReportService.updateDealExceptionReport(param);
        return Result.ok();
    }

    @Operation(summary = "异常上报分页列表", description = "<br>By:刘海泉")
    @PostMapping(value = "pageExceptionReport")
    @UnitCovert(param = false)
    public Result<PageData<OrderChildExceptionReportVO>> pageExceptionReport(@RequestBody @Validated PageExceptionReportParam param) {
        Page<OrderChildExceptionReportVO> page = orderChildExceptionReportService.pageExceptionReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }


    @Operation(summary = "导出异常上报分页列表", description = "<br>By:刘海泉")
    @PostMapping(value = "exportExceptionReport")
    public Result<Object> exportExceptionReport(@RequestBody @Validated PageExceptionReportParam param,
            HttpServletResponse response) throws IOException {
        SXSSFWorkbook workbook = orderChildExceptionReportService.exportExceptionReport(param);
        response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
        workbook.write(response.getOutputStream());
        return Result.ok();
    }

    @Operation(summary = "异常上报详情接口", description = "<br>By:刘海泉")
    @GetMapping(value = "getExceptionReport")
    public Result<OrderChildExceptionReportVO> getExceptionReport(@RequestParam("id") @NotNull(message = "id不能为空") Integer id) {
        return Result.ok(orderChildExceptionReportService.getExceptionReport(id));
    }


    @Operation(summary = "转司机违约", description = "<br>By:刘海泉")
    @PostMapping(value = "transferDriverBreakContract")
    public Result<Object> transferDriverBreakContract(@RequestBody @Validated TransferDriverBreakContractParam param) {
        orderChildExceptionReportService.transferDriverBreakContract(param);
        return Result.ok();
    }




}
